/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: RestWorkSession.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// RestWorkSession.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl;

import java.nio.channels.SelectionKey;

import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.rmi.session.WorkSessionServer;
import openwfe.org.rmi.session.WorkSessionServerImpl;
import openwfe.org.rest.RestUtils;
import openwfe.org.rest.RestService;
import openwfe.org.rest.RmiBridgedRestSession;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.Launchable;
import openwfe.org.worklist.WorkSession;
import openwfe.org.worklist.WorkListException;
import openwfe.org.worklist.impl.XmlWorkItemAndHeaderCoder;


/**
 * An association with a rmi worksession
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: RestWorkSession.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class RestWorkSession

    extends RmiBridgedRestSession

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(RestWorkSession.class.getName());

    //
    // CONSTANTS and DEFINITIONS

    private final static String E_LAUNCHABLES = "launchables";
    private final static String E_LAUNCHABLE = "launchable";
    private final static String A_ENGINE_ID = "engine-id";
    private final static String A_URL = "url";

    //
    // FIELDS

    private WorkSession session = null;
    private XmlWorkItemAndHeaderCoder coder = null;

    //
    // CONSTRUCTORS

    public void init
        (final RestService service, 
         final Long sessionId, 
         final String username,
         final String password)
    throws
        ServiceException
    {
        super.init(service, sessionId, username, password);

        //
        // locating the coder that will be used
        
        final WorkItemCoderLoader loader = openwfe.org.engine.Definitions
            .getWorkItemCoderLoader(this.getService().getContext());

        if (log.isDebugEnabled())
            log.debug("init() loader is "+loader);

        this.coder = (XmlWorkItemAndHeaderCoder)loader.getXmlCoder();

        log.info
            ("HeaderCoder successfully located");
    }

    //
    // METHODS from RestSession

    protected boolean authentify 
        (final String username, final String password)
    throws 
        ServiceException
    {
        try
        {
            this.session = (WorkSession)getWorkSessionServer()
                .login(username, password);
        }
        catch (final Exception e)
        {
            throw new ServiceException("login failed", e);
        }

        return true;
    }

    //
    // METHODS

    //
    // session methods

    public void do_getstorenames
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        do_liststores(key, headers);
    }

    public void do_liststores
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        java.util.List storeNames = this.session.getStoreNames();

        org.jdom.Element eStores = new org.jdom.Element("stores");
        
        java.util.Iterator it = storeNames.iterator();
        while (it.hasNext())
        {
            eStores.addContent(buildStoreElement((String)it.next()));
        }

        reply(key, eStores);
    }

    protected org.jdom.Element buildStoreElement (final String storeName)
        throws Exception
    {
        int count = 0;
        try
        {
            count = this.session.countWorkItems(storeName);
        }
        catch (java.security.AccessControlException ace)
        {
            // ignore
        }

        String permissionString = "";

        try
        {
            if (this.session.checkPermission(storeName, "read"))
                permissionString += "r";
        }
        catch (java.security.AccessControlException ace)
        {
            // ignore
        }

        try
        {
            if (this.session.checkPermission(storeName, "write"))
                permissionString += "w";
        }
        catch (java.security.AccessControlException ace)
        {
            // ignore
        }

        try
        {
            if (this.session.checkPermission(storeName, "delegate"))
                permissionString += "d";
        }
        catch (java.security.AccessControlException ace)
        {
            // ignore
        }

        try
        {
            if (this.session.checkPermission(storeName, "browse"))
                permissionString += "b";
        }
        catch (java.security.AccessControlException ace)
        {
            // ignore
        }

        org.jdom.Element elt = new org.jdom.Element("store");

        elt.setAttribute("name", storeName);
        elt.setAttribute("workitem-count", ""+count);
        elt.setAttribute("permissions", permissionString);

        return elt;
    }

    public void do_getheaders
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        final String storeName = extractStoreName(headers[0]);

        int limit = -1;
        try
        {
            limit = Integer.parseInt
                (RestUtils.extractFromLine(headers[0], "limit"));
        }
        catch (Exception e)
        {
            // ignore
        }

        final java.util.List owfeHeaders = 
            this.session.getHeaders(storeName, limit);

        reply(key, getCoder().encodeHeadersAsXml(owfeHeaders));
    }

    public void do_findflowinstance
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        String storeName = extractStoreName(headers[0]);

        String wfid = null;
        try
        {
            wfid = RestUtils.extractFromLine(headers[0], "id");
        }
        catch (Exception e)
        {
            // ignore
        }

        java.util.List feis = this.session.findFlowInstance(storeName, wfid);

        reply(key, getCoder().encodeIdsAsXml(feis));
    }

    public void do_getworkitem
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        final String storeName = extractStoreName(headers[0]);

        InFlowWorkItem item = null;

        if (headers[0].startsWith("GET "))
        {
            String sid = RestUtils.extractFromLine(headers[0], "id");

            item = this.session.get(storeName, sid);
        }
        else
        {
            final org.jdom.Element reqElt = parseBody(key, headers);

            //log.debug
            //    ("getWorkItem() : request body >\n"+
            //     openwfe.org.Utils.toString(reqElt, "ISO-8859-1"));

            final FlowExpressionId itemId = 
                getCoder().decodeFlowExpressionId(reqElt);

            item = this.session.get(storeName, itemId);
        }

        // debug
        //openwfe.org.Utils.dump
        //    ("rest_4_", 
        //     item.getAttributes().sget("field")
        //      .getBytes(openwfe.org.Utils.getEncoding()));

        reply(key, getCoder().encodeAsXml(item));
    }

    public void do_getandlockworkitem
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        final String storeName = extractStoreName(headers[0]);

        InFlowWorkItem item = null;

        try
        {
            if (headers[0].startsWith("GET "))
            {
                String sid = RestUtils.extractFromLine(headers[0], "id");

                item = this.session.getAndLock(storeName, sid);
            }
            else
            {
                final org.jdom.Element reqElt = parseBody(key, headers);

                final FlowExpressionId fei = 
                    getCoder().decodeFlowExpressionId(reqElt);

                item = this.session.getAndLock(storeName, fei);
            }
        }
        catch (final Exception e)
        {
            log.debug("do_getandlockworkitem() trouble", e);

            rethrowAsHttpException(404, e);
        }

        reply(key, getCoder().encodeAsXml(item));
    }

    public void do_releaseworkitem
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        final String storeName = extractStoreName(headers[0]);

        final org.jdom.Element reqElt = parseBody(key, headers);

        final InFlowWorkItem item = (InFlowWorkItem)getCoder().decode
            (reqElt, null, null);

        try
        {
            this.session.release(storeName, item);
        }
        catch (final Exception e)
        {
            rethrowAsHttpException(403, e);
        }

        reply(key, new org.jdom.Element("ok"));
    }

    public void do_saveworkitem
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        final String storeName = extractStoreName(headers[0]);

        org.jdom.Element reqElt = parseBody(key, headers);

        InFlowWorkItem item = 
            (InFlowWorkItem)getCoder().decode(reqElt, null, null);

        this.session.save(storeName, item);

        reply(key, new org.jdom.Element("ok"));
    }

    public void do_forwardworkitem
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        final String storeName = extractStoreName(headers[0]);

        org.jdom.Element reqElt = parseBody(key, headers);

        InFlowWorkItem item = 
            (InFlowWorkItem)getCoder().decode(reqElt, null, null);

        this.session.forward(storeName, item);

        reply(key, new org.jdom.Element("ok"));
    }

    protected org.jdom.Element encodeLaunchables 
        (final java.util.List launchables)
    {
        org.jdom.Element eLs = new org.jdom.Element(E_LAUNCHABLES);

        java.util.Iterator it = launchables.iterator();
        while (it.hasNext())
        {
            Launchable l = (Launchable)it.next();

            org.jdom.Element e = new org.jdom.Element(E_LAUNCHABLE);
            e.setAttribute(A_ENGINE_ID, l.getEngineId());
            e.setAttribute(A_URL, l.getUrl());

            // TODO : maybe add description here.

            eLs.addContent(e);
        }

        return eLs;
    }

    public void do_listlaunchables
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        reply(key, encodeLaunchables(this.session.getLaunchables()));
    }

    public void do_launchflow
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        final String engineId = RestUtils.extractFromLine
            (headers[0], "engineid");

        org.jdom.Element reqElt = parseBody(key, headers);

        LaunchItem item = 
            (LaunchItem)getCoder().decode(reqElt, null, null);

        //log.debug
        //    ("do_launchflow() field is >"+item.getAttributes().sget("field")+
        //     "<");

        final String flowId = this.session.launch(engineId, item);

        org.jdom.Element eReply = new org.jdom.Element("ok");
        eReply.setAttribute("flow-id", flowId);
        reply(key, eReply);
    }

    public void do_delegate
        (final SelectionKey key, 
         final String[] headers)
    throws 
        Exception
    {
        String storeName = 
            extractStoreName(headers[0]);
        String targetStore = 
            RestUtils.extractFromLine(headers[0], "targetstore");
        String targetParticipant = 
            RestUtils.extractFromLine(headers[0], "targetparticipant");

        org.jdom.Element reqElt = parseBody(key, headers);

        InFlowWorkItem item = 
            (InFlowWorkItem)getCoder().decode(reqElt, null, null);

        if (targetStore != null)
        {
            this.session.delegate
                (storeName, item, targetStore);
        }
        else if (targetParticipant != null)
        {
            this.session.delegateToParticipant
                (storeName, item, targetParticipant);
        }
        else
        {
            throw new WorkListException
                ("'targetstore' or 'targetparticipant' required");
        }

        reply(key, new org.jdom.Element("ok"));
    }

    public XmlWorkItemAndHeaderCoder getCoder ()
    {
        return this.coder;
    }

    //
    // STATIC METHODS

    protected static String extractStoreName (final String firstLine)
        throws java.net.MalformedURLException
    {
        int i = firstLine.indexOf("/worklist/");

        if (i < 0)
        {
            throw new java.net.MalformedURLException
                ("No storeName in >"+firstLine+"<");
        }

        String line = firstLine.substring(i+10);

        i = line.indexOf("?");

        if (i < 0)
        {
            throw new java.net.MalformedURLException
                ("Invalid storeName in >"+line+"<");
        }

        line = line.substring(0, i);

        //log.debug("storeName seems to be >"+line+"<");

        return line;
    }

}
