/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LastModifiedHeaderComparator.java 3310 2006-09-14 14:21:14Z jmettraux $
 */

//
// LastModifiedHeaderComparator.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl;

import openwfe.org.time.Time;
import openwfe.org.worklist.Header;


/**
 * The basic comparator for headers : the youngest workitem's header on top.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-14 16:21:14 +0200 (Thu, 14 Sep 2006) $
 * <br>$Id: LastModifiedHeaderComparator.java 3310 2006-09-14 14:21:14Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class LastModifiedHeaderComparator

    implements java.util.Comparator

{

    static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LastModifiedHeaderComparator.class.getName());

    //
    // CONSTANTS

    public final static LastModifiedHeaderComparator YOUNGER_FIRST 
        = new LastModifiedHeaderComparator();

    public final static LastModifiedHeaderComparator OLDER_FIRST 
        = new LastModifiedHeaderComparator(false);

    //
    // FIELDS

    protected boolean youngerFirst = true;

    //
    // CONSTRUCTORS

    protected LastModifiedHeaderComparator ()
    {
    }

    protected LastModifiedHeaderComparator (boolean youngerFirst)
    {
        this.youngerFirst = youngerFirst;
    }

    //
    // METHODS

    public int compare (Object o1, Object o2)
    {
        if ( ! (o1 instanceof Header && o2 instanceof Header))
            return 0;

        Header h1 = (Header)o1;
        Header h2 = (Header)o2;

        int delta = 0;
        try
        {
            delta = (int)
                (Time.fromIsoDate(h1.getLastModified()) - 
                 Time.fromIsoDate(h2.getLastModified()));
        }
        catch (java.text.ParseException pe)
        {
            log.warn("compare() date parsing failed", pe);
            return 0;
        }

        if ( ! this.youngerFirst) delta = -delta;

        return delta;
    }

    public boolean equals (Object o)
    {
        if (o == null || ! (o instanceof LastModifiedHeaderComparator)) 
            return false;

        LastModifiedHeaderComparator other = (LastModifiedHeaderComparator)o;

        return this.youngerFirst == other.youngerFirst;
    }

}
