/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: InMemoryWorkItemStore.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// InMemoryWorkItemStore.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl;

import javax.security.auth.Subject;

import openwfe.org.auth.BasicPrincipal;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.store.StoreException;


/**
 * Workitems are just held in memory...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: InMemoryWorkItemStore.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class InMemoryWorkItemStore

    extends AbstractWorkItemStore

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(InMemoryWorkItemStore.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private java.util.Map store = new java.util.HashMap(1000);

    //
    // CONSTRUCTORS

    //
    // METHODS from AbstractWorkItemStore

    protected void storeWorkItem (InFlowWorkItem wi)
        throws StoreException
    {
        this.store.put(wi.getLastExpressionId(), wi);
    }

    protected void removeWorkItem (FlowExpressionId fei)
        throws StoreException
    {
        this.store.remove(fei);
    }

    protected InFlowWorkItem retrieveWorkItem (Subject s, FlowExpressionId fei)
        throws StoreException
    {
        return (InFlowWorkItem)this.store.get(fei);
    }

    protected int doCountWorkItems (final Subject s)
        throws StoreException
    {
        return this.store.size();
    }

    protected java.util.List listWorkItems (final Subject s, final int limit)
        throws StoreException
    {
        synchronized (this.store)
        {
            java.util.List result = null;

            if (limit > 0)
                result = new java.util.ArrayList(limit);
            else
                result = new java.util.ArrayList();

            final java.util.Iterator it = this.store.values().iterator();
            while (it.hasNext())
            {
                if (limit > 0 && result.size() >= limit) break;

                final InFlowWorkItem wi = (InFlowWorkItem)it.next();

                result.add(wi);
            }

            return result;
        }
    }

    //
    // METHODS from Service

    public org.jdom.Element getStatus ()
    {
        org.jdom.Element result = new org.jdom.Element(getName());

        return result;
    }

    //
    // METHODS

}
