/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: DefaultHeaderFactory.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// DefaultHeaderFactory.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl;

import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.LongAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.Header;
import openwfe.org.worklist.HeaderFactory;
import openwfe.org.worklist.WorkListException;


/**
 * A default way of summarizing a workitem into a header
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: DefaultHeaderFactory.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class DefaultHeaderFactory

    extends AbstractService

    implements HeaderFactory

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(DefaultHeaderFactory.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from Service

    public org.jdom.Element getStatus ()
    {
        org.jdom.Element result = new org.jdom.Element(getName());

        result.addContent(XmlUtils.getClassElt(this));
        result.addContent(XmlUtils.getRevisionElt("$Id: DefaultHeaderFactory.java 3118 2006-08-30 14:38:36Z jmettraux $"));

        return result;
    }

    //
    // METHODS from HeaderFactory

    /**
     * Produces a Header from a given workitem.
     * LockerName may be null : workitem not locked.
     */
    public Header buildHeader 
        //(final InFlowWorkItem wi, final boolean locked)
        (final InFlowWorkItem wi, final String lockerName)
    throws 
        WorkListException
    {
        //log.debug("entering buildHeader()");

        Header header = new Header();

        //
        // workitem id
        
        header.setExpressionId(wi.getLastExpressionId());

        //
        // last modified

        header.setLastModified(wi.getLastModified());

        //
        // attributes

        StringMapAttribute attributes = new StringMapAttribute();

        attributes.puts
            (Header.WF_INSTANCE_ID, 
             wi.getLastExpressionId().getWorkflowInstanceId());

        attributes.puts
            (Header.WF_DEFINITION_NAME, 
             wi.getLastExpressionId().getWorkflowDefinitionName());

        attributes.puts
            (Header.WF_DEFINITION_REVISION, 
             wi.getLastExpressionId().getWorkflowDefinitionRevision());

        attributes.puts
            (Header.WF_DEFINITION_URL, 
             wi.getLastExpressionId().getWorkflowDefinitionUrl());

        attributes.puts
            (Header.DISPATCH_TIME,
             wi.getDispatchTime());

        attributes.puts
            (Header.PARTICIPANT_NAME,
             wi.getParticipantName());

        StringAttribute subject = 
            (StringAttribute)wi.getAttribute(Header.SUBJECT);
        if (subject == null) 
        {
            subject = new StringAttribute("--none--");
        }
        attributes.put
            (Header.SUBJECT, 
             subject);

        if (lockerName != null)
        {
            header.setLocked(true);

            attributes.puts(Header.LOCKER_NAME, lockerName);
        }

        //

        header.setAttributes(attributes);

        //log.debug("leaving buildHeader()");

        return header;
    }

}
