/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: StorePermission.java 3370 2006-09-23 14:04:24Z jmettraux $
 */

//
// StorePermission.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.auth;

import java.security.PermissionCollection;
import openwfe.org.auth.Permission;
import openwfe.org.auth.AuthException;


/**
 * A permission for a workitem store
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-23 16:04:24 +0200 (Sat, 23 Sep 2006) $
 * <br>$Id: StorePermission.java 3370 2006-09-23 14:04:24Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class StorePermission

    extends Permission

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(StorePermission.class.getName());

    //
    // CONSTANTS (definitions)

    public final static String P_RIGHTS 
        = "rights";
    public final static String P_ACTIONS 
        = "actions";

    private final static int NONE       = 0x0;

    private final static int READ       = 0x1;
    private final static int WRITE      = 0x2;
    private final static int DELEGATE   = 0x4;
    private final static int BROWSE     = 0x8;

    private final static int ALL        = READ | WRITE | DELEGATE | BROWSE;

    //
    // FIELDS

    private int mask = NONE;
    private transient String action = null;

    //
    // CONSTRUCTORS

    public StorePermission (final java.util.Map params)
    {
        super(params);

        String actions = (String)params.get(P_RIGHTS);
        if (actions == null) actions = (String)params.get(P_ACTIONS);
        this.mask = getMask(actions);

        this.action = null; // so that it gets recomputed

        log.debug("constructor(m) "+this.toString());
    }

    /**
     * a helper method
     */
    public static StorePermission newStorePermission 
        (final String name, final String actions)
    {
        final java.util.Map params = new java.util.HashMap(2);

        params.put(NAME, name);
        params.put(P_RIGHTS, actions);

        return new StorePermission(params);
    }

    //
    // METHODS

    public int getMask ()
    {
        return this.mask;
    }

    //
    // METHODS from Permission

    public int hashCode ()
    {
        return (this.getName().hashCode() ^ this.mask);
    }

    public boolean equals (Object o)
    {
        if ( ! (o instanceof StorePermission)) return false;

        StorePermission other = (StorePermission)o;

        return 
            (getName().equals(other.getName()) &&
             this.mask == other.mask);
    }

    public boolean implies (final java.security.Permission p)
    {
        if (log.isDebugEnabled())
        {
            log.debug
                ("implies() does "+this+" imply "+p+" ?");
        }

        if (p == null || ! (p instanceof StorePermission)) return false;

        if (log.isDebugEnabled())
        {
            log.debug
                ("implies() does '"+p.getName()+"' match '"+this.getName()+"'");
        }

        if ( ! p.getName().matches(this.getName())) return false;

        //
        // check the actions
        
        final StorePermission sp = (StorePermission)p;

        if (log.isDebugEnabled())
        {
            log.debug
                ("implies() result is "+((this.mask & sp.mask) == sp.mask));
        }

        return ((this.mask & sp.mask) == sp.mask);
    }

    public PermissionCollection newPermissionCollection ()
    {
        return new StorePermissionCollection();
    }

    public String toString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("<StorePermission name=\"");
        sb.append(getName());
        sb.append("\" actions=\"");

        if ((this.mask & READ) == READ) sb.append('r'); else sb.append('-');
        if ((this.mask & WRITE) == WRITE) sb.append('w'); else sb.append('-');
        if ((this.mask & DELEGATE) == DELEGATE) sb.append('d'); else sb.append('-');
        if ((this.mask & BROWSE) == BROWSE) sb.append('b'); else sb.append('-');

        sb.append("\" />");

        return sb.toString();
    }

    //
    // some static METHODS

    /*
    protected static String removeWildcard (String s)
    {
        if (s.length() < 1) return ".";

        if ( ! s.endsWith("*")) return (s + '!');

        return s.substring(0, s.length()-1);
    }

    public static boolean namesMatch (String n1, String n2)
    {
        n1 = removeWildcard(n1);
        n2 = removeWildcard(n2);

        log.debug("namesMatch() \""+n2+"\".startsWith(\""+n1+"\") ?");

        return n2.startsWith(n1);
    }
    */

    public static int getMask (String actions)
    {
        int mask = NONE;

        if (actions == null) return mask;

        //log.debug("getMask() actions >"+actions+"<");

        String[] actionArray = actions.toLowerCase().split(",");

        for (int i=0; i < actionArray.length; i++)
        {
            String action = actionArray[i].trim();

            //log.debug("getMask() parsed action >"+action+"<");

            if (action.equals("read"))
            {
                mask |= READ;
                mask |= BROWSE;
            }
            else if (action.equals("write"))
            {
                mask |= WRITE;
            }
            else if (action.equals("delegate"))
            {
                mask |= DELEGATE;
            }
            else if (action.equals("browse"))
            {
                mask |= BROWSE;
            }
        }

        //log.debug("getMask() mask is "+mask);

        return mask;
    }

    public String getActions ()
    {
        if (this.action == null)
        {
            StringBuffer result = new StringBuffer();

            if ((this.mask & READ) == READ) 
                result.append("read");

            if ((this.mask & WRITE) == WRITE) 
            {
                if (result.length() > 0) result.append(",");

                result.append("write");
            }

            if ((this.mask & DELEGATE) == DELEGATE) 
            {
                if (result.length() > 0) result.append(",");

                result.append("delegate");
            }

            if ((this.mask & BROWSE) == BROWSE) 
            {
                if (result.length() > 0) result.append(",");

                result.append("browse");
            }

            this.action = result.toString();
        }
                
        return this.action;
    }

}

//
// ANOTHER CLASS

//
// StorePermissionCollection.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

/**
 * A collection of store permission instances.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-23 16:04:24 +0200 (Sat, 23 Sep 2006) $
 * <br>$Id: StorePermission.java 3370 2006-09-23 14:04:24Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
final class StorePermissionCollection

    extends PermissionCollection

    implements java.io.Serializable

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(StorePermissionCollection.class.getName());

    //
    // FIELDS

    private java.util.Vector permissions = new java.util.Vector();

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void add (java.security.Permission p)
    {
        if (p == null || ! (p instanceof StorePermission))
        {
            throw new IllegalArgumentException
                ("null permission or permission not of class '"+
                 StorePermission.class.getName()+"'");
        }

        if (isReadOnly())
        {
            throw new SecurityException
                ("attempt to add a Permission to a readonly "+
                 "PermissionCollection");
        }

        permissions.add(p);
    }

    public boolean implies (java.security.Permission p)
    {
        if (p == null || ! (p instanceof StorePermission)) return false;

        //log.debug("implies() does collection implies "+p.toString());

        StorePermission sp = (StorePermission)p;

        int desiredMask = sp.getMask();
        int effectiveMask = 0;
        int neededMask = desiredMask;

        java.util.Enumeration en = elements();

        while(en.hasMoreElements())
        {
            StorePermission esp = (StorePermission)en.nextElement();

            log.debug("implies() does "+esp+" imply "+p+" ?");

            if (((neededMask & esp.getMask()) != 0) &&
                p.getName().matches(esp.getName()))
            {
                effectiveMask |= esp.getMask();

                if ((effectiveMask & desiredMask) == desiredMask)
                {
                    //log.debug("implies() true!");
                    return true;
                }

                neededMask = (desiredMask ^ effectiveMask);
            }
        }

        //log.debug("implies() false!");
        return false;
    }

    public java.util.Enumeration elements ()
    {
        return permissions.elements();
    }

}

