/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LaunchPermission.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// LaunchPermission.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.auth;

import java.security.PermissionCollection;

import openwfe.org.xml.XmlUtils;
import openwfe.org.auth.Permission;


/**
 * A permission for a workitem store
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: LaunchPermission.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class LaunchPermission

    extends Permission

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LaunchPermission.class.getName());

    //
    // CONSTANTS (definitions)

    public final static String LAUNCH_ACTIONS 
        = "launch";

    private final static String LAUNCHITEM = "launchitem";
    //private final static String FLOWDEF = "workflow-definition";
    private final static String FLOWS = "flows";
    private final static String FLOW = "flow";

    //
    // FIELDS

    protected String engineId = null;
    protected String flowUrl = null;

    //
    // CONSTRUCTORS

    public LaunchPermission (final java.util.Map params)
    {
        super(params);
        splitName((String)params.get(NAME));

        //openwfe.org.Utils.logStackTrace(log, "LaunchPermission.new()");
    }

    public static LaunchPermission newLaunchPermission (final String name)
    {
        final java.util.Map params = new java.util.HashMap(1);
        params.put(NAME, name);

        return new LaunchPermission(params);
    }

    protected void splitName (String s)
    {
        String[] ss = s.split("::");

        if (ss.length < 2)
        {
            splitName(".*::"+s);
            return;
        }

        this.engineId = ss[0];
        this.flowUrl = ss[1];

        //log.debug("splitName()  '"+this.engineId+"' :: '"+this.flowUrl+"'");
    }

    //
    // METHODS
    
    public String getEngineId () { return this.engineId; }
    public String getUrl () { return this.flowUrl; }

    /**
     * Returns all the url concerned by this launchPermission. 
     * If the permission points to a list of flow, their URLs
     * are all returned.
     * The result is not cached, so you can drop in new flowdefs or flowlists 
     * and they will be seen.
     */
    public java.util.List resolveUrl ()
    {
        java.util.ArrayList result = new java.util.ArrayList();

        resolveUrl(result, this.flowUrl);

        return result;
    }

    /**
     * The workhorse of the previous method.
     * Url pointing to list of urls that point to list of urls... are
     * possible, this method is recursive.
     */
    protected void resolveUrl (final java.util.List result, final String url)
    {
        //
        // is it a regexp ?

        if (url.endsWith("*"))
        {
            result.add(url);
            return;
        }

        //
        // not a regexp/glob...

        org.jdom.Element docRootElement = null;
        try
        {
            docRootElement = XmlUtils.extractXml(new java.net.URL(url), false);
        }
        catch (final Throwable t)
        {
            //log.warn("Couldn't parse document "+url, t);
            log.warn("Couldn't parse document "+url+" because of "+t);
            return;
        }

        if (docRootElement.getName().equals(FLOWS))
        {
            java.util.Iterator it = docRootElement.getChildren(FLOW).iterator();
            while (it.hasNext())
            {
                org.jdom.Element elt = (org.jdom.Element)it.next();
                String childUrl = elt.getTextTrim(); 

                resolveUrl(result, childUrl);
                    // this can get recursive...
            }
            return;
        }

        result.add(url);
    }

    /*
     * A less static replacement has to be found... Expression Map 
     * where are you ?
     *
     * (moved out : was too static)
     * /
    private boolean isFlowDefinition (final org.jdom.Element rootElement)
    {
        final String name = rootElement.getName();

        return 
            (name.equals("define") ||
             name.equals("process-definition") ||
             name.equals("workflow-definition"));
    }
     */

    //
    // METHODS from Permission

    public String getActions ()
    {
        return LAUNCH_ACTIONS;
    }

    public int hashCode ()
    {
        return this.getName().hashCode();
    }

    public boolean equals (Object o)
    {
        if (o == null || ! (o instanceof LaunchPermission)) return false;

        LaunchPermission other = (LaunchPermission)o;

        return 
            (getName().equals(other.getName()));
    }

    public boolean implies (final java.security.Permission p)
    {
        //log.debug("implies() does "+this+" imply "+p+" ?");

        if (p == null || ! (p instanceof LaunchPermission)) return false;

        //log.debug("implies() does "+this+" imply "+p+" ?");
        
        final LaunchPermission lp = (LaunchPermission)p;

        //
        // engine implies

        //if ( ! this.engineId.equals("*"))
        //{
        //    if ( ! this.engineId.equals(lp.engineId)) return false;
        //}

        if ( ! lp.engineId.matches(this.engineId)) return false;

        //
        // flow implies

        if (this.flowUrl.equals(".*")) return true;

        java.util.Iterator it = lp.resolveUrl().iterator();
        while (it.hasNext())
        {
            String url = (String)it.next();
            if (matches(this.resolveUrl(), url)) return true;
        }

        //log.debug("implies() returning false");

        return false;
    }

    /*
     * Returns true as soon as one of the authorized urls matches the given
     * url.
     */
    private boolean matches 
        (final java.util.List authorizedUrls, final String url)
    {
        final java.util.Iterator it = authorizedUrls.iterator();
        while (it.hasNext())
        {
            final String aUrl = (String)it.next();

            //log.debug("matches() does \""+url+"\" match \""+aUrl+"\" ?");

            if (url.matches(aUrl)) return true;
        }

        //log.debug("matches() returning false");

        return false;
    }

    public PermissionCollection newPermissionCollection ()
    {
        return new LaunchPermissionCollection();
    }

    public String toString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("[LaunchPermission \n  name=\"");
        sb.append(getName());
        sb.append("\" \n/]");

        return sb.toString();
    }

    //
    // some static METHODS

    /*
    public static void main (String[] args)
    {
        String n1 = args[0];
        String n2 = args[1];

        boolean b = namesMatch(n1, n2);

        System.out.println("'"+n1+"' matches '"+n2+"' -> "+b);
    }
    */

}

//
// ANOTHER CLASS

//
// LaunchPermissionCollection.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: LaunchPermission.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
final class LaunchPermissionCollection

    extends PermissionCollection

    implements java.io.Serializable

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LaunchPermissionCollection.class.getName());

    //
    // FIELDS

    private java.util.Vector permissions = new java.util.Vector();

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void add (java.security.Permission p)
    {
        if (p == null || ! (p instanceof LaunchPermission))
        {
            throw new IllegalArgumentException
                ("null permission or permission not of class '"+
                 LaunchPermission.class.getName()+"'");
        }

        if (isReadOnly())
        {
            throw new SecurityException
                ("attempt to add a Permission to a readonly "+
                 "PermissionCollection");
        }

        permissions.add(p);
    }

    public boolean implies (final java.security.Permission p)
    {
        //log.debug("does "+this+" implies "+p+" ?");

        if (p == null || ! (p instanceof LaunchPermission)) return false;

        LaunchPermission lp = (LaunchPermission)p;

        final java.util.Enumeration en = elements();
        while (en.hasMoreElements())
        {
            LaunchPermission elp = (LaunchPermission)en.nextElement();

            //log.debug("does "+elp+" implies "+p+" ?");

            if (elp.implies(p)) return true;
        }

        return false;
    }

    public java.util.Enumeration elements ()
    {
        return permissions.elements();
    }

}

