/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: DelegationPermission.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// DelegationPermission.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.auth;

import java.security.PermissionCollection;
import openwfe.org.auth.Permission;


/**
 * Symobilizes the permission a user has to delegate to a participant
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: DelegationPermission.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class DelegationPermission

    extends Permission

{

    /*
    private final static org.apache.log4j.Logger log =
        org.apache.log4j.Logger.getLogger(DelegationPermission.class.getName());
    */

    //
    // CONSTANTS (definitions)

    public final static String DELEGATE_ACTIONS 
        = "delegate";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public DelegationPermission (final java.util.Map params)
    {
        super(params);
    }

    //
    // METHODS

    //
    // METHODS from Permission

    public String getActions ()
    {
        return DELEGATE_ACTIONS;
    }

    public int hashCode ()
    {
        return this.getName().hashCode();
    }

    public boolean equals (Object o)
    {
        if (o == null || ! (o instanceof DelegationPermission)) return false;

        DelegationPermission other = (DelegationPermission)o;

        return 
            (getName().equals(other.getName()));
    }

    public boolean implies (java.security.Permission p)
    {
        if (p == null || ! (p instanceof DelegationPermission)) return false;

        //log.debug("does "+this+" implies "+p+" ?");
        
        DelegationPermission dp = (DelegationPermission)p;

        return this.getName().equals(dp.getName());
    }

    public PermissionCollection newPermissionCollection ()
    {
        return new DelegationPermissionCollection();
    }

    public String toString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("<DelegationPermission \n  name=\"");
        sb.append(getName());
        sb.append("\" \n/>");

        return sb.toString();
    }

    //
    // some static METHODS

    /*
    public static void main (String[] args)
    {
        String n1 = args[0];
        String n2 = args[1];

        boolean b = namesMatch(n1, n2);

        System.out.println("'"+n1+"' matches '"+n2+"' -> "+b);
    }
    */

}

//
// ANOTHER CLASS

//
// DelegationPermissionCollection.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: DelegationPermission.java 3118 2006-08-30 14:38:36Z jmettraux $
 *
 * @author jmettraux@openwfe.org
 */
final class DelegationPermissionCollection

    extends PermissionCollection

    implements java.io.Serializable

{

    static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(DelegationPermissionCollection.class.getName());

    //
    // FIELDS

    private java.util.Vector permissions = new java.util.Vector();

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void add (java.security.Permission p)
    {
        if (p == null || ! (p instanceof DelegationPermission))
        {
            throw new IllegalArgumentException
                ("null permission or permission not of class '"+
                 DelegationPermission.class.getName()+"'");
        }

        if (isReadOnly())
        {
            throw new SecurityException
                ("attempt to add a Permission to a readonly "+
                 "PermissionCollection");
        }

        permissions.add(p);
    }

    public boolean implies (java.security.Permission p)
    {
        if (p == null || ! (p instanceof DelegationPermission)) return false;

        DelegationPermission dp = (DelegationPermission)p;

        java.util.Enumeration en = elements();
        while(en.hasMoreElements())
        {
            DelegationPermission edp = (DelegationPermission)en.nextElement();

            //log.debug("does "+edp+" implies "+dp+" ?");

            if (edp.implies(dp)) return true;
        }

        return false;
    }

    public java.util.Enumeration elements ()
    {
        return permissions.elements();
    }

}

