/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AuditLogger.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// AuditLogger.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.audit;

import javax.security.auth.Subject;

import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * An AuditLogger is used to log modifications made to workitems. It is used
 * by the worklist action AuditedSaveAction (which in turn, is used by the
 * AuditedRmiWorkSession).<br>
 * This developement has been sponsored by http://www.obinary.com
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AuditLogger.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface AuditLogger
{

    ///**
    // * Logs a launch item
    // */
    //public void logLaunch 
    //    (Subject s, LaunchItem item);

    ///**
    // * Logs a delta between a workitem and its original.
    // */
    //public void logDelta 
    //    (Subject s, InFlowWorkItem origItem, InFlowWorkItem newItem);

    /**
     * Logs when a field got removed from a workitem.
     */
    public void logFieldRemoval 
        (Subject s,
         InFlowWorkItem currentItem, 
         String action,
         String fieldName);

    /**
     * Logs a modification to an already existing field.
     */
    public void logFieldModification
        (Subject s,
         InFlowWorkItem currentItem, 
         String action,
         String fieldName, 
         Attribute original, 
         Attribute modified);

    /**
     * Logs the apparition of a new field in the workitem.
     */
    public void logNewField
        (Subject s,
         WorkItem item, 
         String action,
         String fieldName, 
         Attribute attribute);

}
