/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ListWorkItemConsumer.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// ListWorkItemConsumer.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist;

import openwfe.org.OpenWfeException;
import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.listen.AbstractWorkItemConsumer;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.InFlowItem;
import openwfe.org.engine.workitem.CancelItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.worklist.store.WorkItemStore;


/**
 * This consumer is rather easy, it takes as input a workitem (coming
 * from the listener in the worklist configuration), lookups its participant
 * name and then stores it accordingly in a workitem store.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: ListWorkItemConsumer.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ListWorkItemConsumer

    extends AbstractWorkItemConsumer

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ListWorkItemConsumer.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    /**
     * This method looks at the wi and either reply to the corresponding
     * ParticipantExpression either launch a new wf.
     */
    public Object use (final WorkItem wi)
        throws OpenWfeException
    {
        //
        // we don't want launch items here

        if ( ! (wi instanceof InFlowItem))
        {
            throw new OpenWfeException
                ("Worklists do not accept launch items.");
        }

        log.debug
            ("use() Received a workitem of class '"+wi.getClass().getName()+
             "' for '"+((InFlowItem)wi).getId()+"'");

        //
        // find a store that accepts our participant

        final WorkItemStore store = determineStore((InFlowItem)wi);

        log.debug("use() giving wi to store '"+store.getName()+"'");
        
        //
        // store

        if (wi instanceof InFlowWorkItem)
            store.store((InFlowWorkItem)wi);
        else
            store.cancel((CancelItem)wi);

        //
        // no particular reply

        return null;
    }

    /**
     * Determines into which store workitems should go.
     */
    protected WorkItemStore determineStore (final InFlowItem item)
    {
        WorkItemStore defaultStore = null;

        final String participantName = item.getParticipantName();

        final java.util.Iterator it = 
            getContext().itemsOfClass(WorkItemStore.class).iterator();

        while (it.hasNext())
        {
            final WorkItemStore s = (WorkItemStore)it.next();

            if (s.acceptsWorkItemsFor(participantName)) return s;

            if (s.isDefaultStore()) defaultStore = s;
        }

        return defaultStore; // default
    }

    //
    // METHODS from Service

    public org.jdom.Element getStatus ()
    {
        org.jdom.Element result = new org.jdom.Element(getName());

        result.addContent(XmlUtils.getClassElt(this));
        result.addContent(XmlUtils.getRevisionElt("$Id: ListWorkItemConsumer.java 3118 2006-08-30 14:38:36Z jmettraux $"));

        return result;
    }

}
