/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Header.java 3334 2006-09-17 06:19:18Z jmettraux $
 */

//
// Header.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist;

import openwfe.org.time.Time;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * A header is a light representation of a workitem. It is intended for
 * worklist display and should contain information a user whould use to
 * decide wether it should process the workitem before or after another
 * workitem.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-17 08:19:18 +0200 (Sun, 17 Sep 2006) $
 * <br>$Id: Header.java 3334 2006-09-17 06:19:18Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class Header

    implements java.io.Serializable, Comparable

{

    static final long serialVersionUID = -7752432766042716755L;

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Header.class.getName());

    //
    // CONSTANTS (definitions)

    public final static String WF_INSTANCE_ID
        = "__wfi_id__";

    public final static String WF_DEFINITION_NAME
        = "__wfd_name__";

    public final static String WF_DEFINITION_REVISION
        = "__wfd_revision__";

    public final static String WF_DEFINITION_URL
        = "__wfd_url__";

    public final static String SUBJECT
        = "__subject__";

    public final static String DISPATCH_TIME
        = "__dispatch_time__";

    public final static String LOCKER_NAME
        = "__locker_name__";

    public final static String PARTICIPANT_NAME
        = openwfe.org.engine.participants.Participant.PARTICIPANT_NAME;

    //
    // FIELDS

    private transient String stringId = null;
        // this string is used by header maps for easy retrieval

    private FlowExpressionId expressionId = null;
    private StringMapAttribute attributes = null;
    private String lastModified = null;
    private boolean locked = false;

    //
    // CONSTRUCTORS

    /**
     * The classical no-param constructor.
     */
    public Header ()
    {
        super();
    }

    //
    // METHODS

    public void setAttribute (String attributeName, Attribute attributeValue)
    {
        this.attributes.put(attributeName, attributeValue);
    }

    public Attribute getAttribute (String attributeName)
    {
        return this.attributes.aget(attributeName);
    }

    /**
     * Returns an XML string representation of this header.
     */
    public String toString ()
    {
        try
        {
            return openwfe.org.util.beancoder.XmlBeanCoder
                .encodeToString(this, null);
                    //
                    // setting the encoding to 'null' means :
                    // use the default encoding (as set in the start scripts)
        }
        catch (final Exception e)
        {
            return "Failed to encode header because of "+e;
        }
    }

    //
    // BEAN METHODS

    public FlowExpressionId getExpressionId () { return this.expressionId; }
    public String getLastModified () { return this.lastModified; }
    public boolean isLocked () { return this.locked; }
    public StringMapAttribute getAttributes () { return this.attributes; }
    public String getStringId () { return this.stringId; }


    public void setExpressionId (final FlowExpressionId fei) { this.expressionId = fei; }
    public void setLastModified (final String isoDate) { this.lastModified = isoDate; }
    public void setLocked (final boolean b) { this.locked = b; }
    public void setAttributes (final StringMapAttribute m) { this.attributes = m; }
    public void setStringId (final String s) { this.stringId = s; }

    //
    // METHODS from Comparable

    /**
     * This comparator helps sorting the headers by their 'lastModified'
     * date.
     */
    public int compareTo (final Object o)
    {
        if (o == null) return 0;

        if ( ! (o instanceof Header))
        {
            throw new ClassCastException
                ("Cannot compare a Header to some '"+
                 o.getClass().getName()+"'");
        }

        Header that = (Header)o;

        try
        {
            return 
                (int)(Time.fromIsoDate(that.lastModified) - 
                      Time.fromIsoDate(this.lastModified));
        }
        catch (java.text.ParseException pe)
        {
            log.warn("compareTo() date parsing failed", pe);
            return 0;
        }
    }

}
