/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Definitions.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// Definitions.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist;

import openwfe.org.ApplicationContext;
import openwfe.org.query.QueryMap;
import openwfe.org.worklist.audit.AuditLogger;


/**
 * Constants for the worklist application
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: Definitions.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public abstract class Definitions
{

    /**
     * This constant contains 'headerFactory' which is the name of the
     * default header factory available to workitem stores in the
     * application context.
     */
    public final static String S_HEADER_FACTORY
        = "headerFactory";

    /**
     * 'queryMap' is the name of the query map service. This service
     * is used to load and prepare queries for query strategies.
     */
    public final static String S_QUERY_MAP
        = "queryMap";

    /**
     * 'auditLogger' is the name of the AuditLogger service, that the
     * AuditedRmiWorkSession requires.
     */
    public final static String S_AUDIT_LOGGER
        = "auditLogger";

    //
    // stores
    
    public final static HeaderFactory getHeaderFactory 
        (final ApplicationContext context)
    {
        return (HeaderFactory)context.lookup(S_HEADER_FACTORY);
    }

    public final static QueryMap getQueryMap
        (final ApplicationContext context)
    {
        return (QueryMap)context.get(S_QUERY_MAP);
    }

    public final static AuditLogger getAuditLogger
        (final ApplicationContext context)
    {
        return (AuditLogger)context.get(S_AUDIT_LOGGER);
    }

}
