/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucp;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.openucx.jucx.UcxException;
import org.openucx.jucx.UcxParams;
import org.openucx.jucx.ucp.UcpConstants;
import org.openucx.jucx.ucs.UcsConstants;

public class UcpWorkerParams
extends UcxParams {
    private int threadMode;
    private BitSet cpuMask = new BitSet();
    private long events;
    private ByteBuffer userData;
    private int eventFD;

    @Override
    public UcpWorkerParams clear() {
        super.clear();
        this.threadMode = 0;
        this.cpuMask = new BitSet();
        this.events = 0L;
        this.userData = null;
        this.eventFD = 0;
        return this;
    }

    public UcpWorkerParams requestThreadSafety() {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_THREAD_MODE;
        this.threadMode = UcsConstants.ThreadMode.UCS_THREAD_MODE_MULTI;
        return this;
    }

    public UcpWorkerParams setCpu(int cpuNum) {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_CPU_MASK;
        this.cpuMask.set(cpuNum);
        return this;
    }

    public UcpWorkerParams requestWakeupRMA() {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_EVENTS;
        this.events |= UcpConstants.UCP_WAKEUP_RMA;
        return this;
    }

    public UcpWorkerParams requestWakeupAMO() {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_EVENTS;
        this.events |= UcpConstants.UCP_WAKEUP_AMO;
        return this;
    }

    public UcpWorkerParams requestWakeupTagSend() {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_EVENTS;
        this.events |= UcpConstants.UCP_WAKEUP_TAG_SEND;
        return this;
    }

    public UcpWorkerParams requestWakeupTagRecv() {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_EVENTS;
        this.events |= UcpConstants.UCP_WAKEUP_TAG_RECV;
        return this;
    }

    public UcpWorkerParams requestWakeupTX() {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_EVENTS;
        this.events |= UcpConstants.UCP_WAKEUP_TX;
        return this;
    }

    public UcpWorkerParams requestWakeupRX() {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_EVENTS;
        this.events |= UcpConstants.UCP_WAKEUP_RX;
        return this;
    }

    public UcpWorkerParams requestWakeupEdge() {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_EVENTS;
        this.events |= UcpConstants.UCP_WAKEUP_EDGE;
        return this;
    }

    public UcpWorkerParams setUserData(ByteBuffer userData) {
        if (!userData.isDirect()) {
            throw new UcxException("User data must be of type DirectByteBuffer.");
        }
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_USER_DATA;
        this.userData = userData;
        return this;
    }

    public UcpWorkerParams setEventFD(int eventFD) {
        this.fieldMask |= UcpConstants.UCP_WORKER_PARAM_FIELD_EVENT_FD;
        this.eventFD = eventFD;
        return this;
    }
}

