/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucp;

import java.io.Closeable;
import java.net.InetSocketAddress;
import org.openucx.jucx.UcxException;
import org.openucx.jucx.UcxNativeStruct;
import org.openucx.jucx.ucp.UcpListenerConnectionHandler;
import org.openucx.jucx.ucp.UcpListenerParams;
import org.openucx.jucx.ucp.UcpWorker;

public class UcpListener
extends UcxNativeStruct
implements Closeable {
    private InetSocketAddress address;
    private UcpListenerConnectionHandler connectionHandler;

    public UcpListener(UcpWorker worker, UcpListenerParams params) {
        if (params.getSockAddr() == null) {
            throw new UcxException("UcpListenerParams.sockAddr must be non-null.");
        }
        if (params.connectionHandler == null) {
            throw new UcxException("Connection handler must be set");
        }
        this.connectionHandler = params.connectionHandler;
        this.address = params.getSockAddr();
        this.setNativeId(UcpListener.createUcpListener(params, worker.getNativeId()));
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public void close() {
        UcpListener.destroyUcpListenerNative(this.getNativeId());
        this.setNativeId(null);
    }

    private static native long createUcpListener(UcpListenerParams var0, long var1);

    private static native void destroyUcpListenerNative(long var0);
}

