/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucp;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.openucx.jucx.UcxParams;
import org.openucx.jucx.ucp.UcpConnectionRequest;
import org.openucx.jucx.ucp.UcpConstants;
import org.openucx.jucx.ucp.UcpEndpointErrorHandler;

public class UcpEndpointParams
extends UcxParams {
    private ByteBuffer ucpAddress;
    private int errorHandlingMode;
    private long flags;
    private InetSocketAddress socketAddress;
    private InetSocketAddress clientAddress;
    private long connectionRequest;
    UcpEndpointErrorHandler errorHandler;

    public String toString() {
        String result = "UcpEndpointParams{";
        if (this.ucpAddress != null) {
            result = result + "ucpAddress,";
        }
        result = result + "errorHandlingMode=" + (this.errorHandlingMode == 0 ? "UCP_ERR_HANDLING_MODE_NONE," : "UCP_ERR_HANDLING_MODE_PEER,");
        if (this.socketAddress != null) {
            result = result + "socketAddress=" + this.socketAddress.toString() + ",";
        }
        if (this.connectionRequest != 0L) {
            result = result + "connectionRequest" + (this.clientAddress != null ? this.clientAddress.toString() : "");
        }
        return result;
    }

    @Override
    public UcpEndpointParams clear() {
        super.clear();
        this.ucpAddress = null;
        this.errorHandlingMode = 0;
        this.flags = 0L;
        this.socketAddress = null;
        this.connectionRequest = 0L;
        this.clientAddress = null;
        this.errorHandler = null;
        return this;
    }

    public UcpEndpointParams setUcpAddress(ByteBuffer ucpAddress) {
        this.fieldMask |= UcpConstants.UCP_EP_PARAM_FIELD_REMOTE_ADDRESS;
        this.ucpAddress = ucpAddress;
        return this;
    }

    public UcpEndpointParams setPeerErrorHandlingMode() {
        this.fieldMask |= UcpConstants.UCP_EP_PARAM_FIELD_ERR_HANDLING_MODE;
        this.errorHandlingMode = UcpConstants.UCP_ERR_HANDLING_MODE_PEER;
        return this;
    }

    public UcpEndpointParams setSocketAddress(InetSocketAddress socketAddress) {
        this.fieldMask |= UcpConstants.UCP_EP_PARAM_FIELD_SOCK_ADDR | UcpConstants.UCP_EP_PARAM_FIELD_FLAGS;
        this.flags |= UcpConstants.UCP_EP_PARAMS_FLAGS_CLIENT_SERVER;
        this.socketAddress = socketAddress;
        return this;
    }

    public UcpEndpointParams setNoLoopbackMode() {
        this.fieldMask |= UcpConstants.UCP_EP_PARAM_FIELD_FLAGS;
        this.flags |= UcpConstants.UCP_EP_PARAMS_FLAGS_NO_LOOPBACK;
        return this;
    }

    public UcpEndpointParams setConnectionRequest(UcpConnectionRequest connectionRequest) {
        this.fieldMask |= UcpConstants.UCP_EP_PARAM_FIELD_CONN_REQUEST;
        this.connectionRequest = connectionRequest.getNativeId();
        if (connectionRequest.getClientAddress() != null) {
            this.clientAddress = connectionRequest.getClientAddress();
        }
        return this;
    }

    public UcpEndpointParams setErrorHandler(UcpEndpointErrorHandler errorHandler) {
        this.fieldMask |= UcpConstants.UCP_EP_PARAM_FIELD_ERR_HANDLER;
        this.errorHandler = errorHandler;
        return this;
    }
}

