/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucp;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.openucx.jucx.NativeLibs;
import org.openucx.jucx.UcxException;
import org.openucx.jucx.UcxNativeStruct;
import org.openucx.jucx.UcxUtils;
import org.openucx.jucx.ucp.UcpMemMapParams;
import org.openucx.jucx.ucp.UcpMemory;
import org.openucx.jucx.ucp.UcpParams;
import org.openucx.jucx.ucp.UcpWorker;
import org.openucx.jucx.ucp.UcpWorkerParams;

public class UcpContext
extends UcxNativeStruct
implements Closeable {
    public UcpContext(UcpParams params) {
        this.setNativeId(UcpContext.createContextNative(params));
    }

    @Override
    public void close() {
        UcpContext.cleanupContextNative(this.getNativeId());
        this.setNativeId(null);
    }

    public long getMemoryTypesMask() {
        return UcpContext.queryMemTypesNative(this.getNativeId());
    }

    public UcpWorker newWorker(UcpWorkerParams params) {
        return new UcpWorker(this, params);
    }

    public UcpMemory registerMemory(ByteBuffer buf) {
        if (!buf.isDirect()) {
            throw new UcxException("Registered buffer must be direct");
        }
        UcpMemMapParams params = new UcpMemMapParams().setAddress(UcxUtils.getAddress(buf)).setLength(buf.remaining());
        UcpMemory result = this.memoryMapNative(this.getNativeId(), params);
        result.setByteBufferReference(buf);
        return result;
    }

    public UcpMemory memoryMap(UcpMemMapParams params) {
        return this.memoryMapNative(this.getNativeId(), params);
    }

    private static native long createContextNative(UcpParams var0);

    private static native long queryMemTypesNative(long var0);

    private static native void cleanupContextNative(long var0);

    private native UcpMemory memoryMapNative(long var1, UcpMemMapParams var3);

    static {
        NativeLibs.load();
    }
}

