/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucp;

import java.io.Closeable;
import java.io.IOException;
import org.openucx.jucx.UcxCallback;
import org.openucx.jucx.UcxException;
import org.openucx.jucx.ucp.UcpConstants;
import org.openucx.jucx.ucp.UcpRequest;
import org.openucx.jucx.ucp.UcpWorker;
import org.openucx.jucx.ucs.UcsConstants;

public class UcpAmData
implements Closeable {
    private final UcpWorker worker;
    private final long address;
    private final long length;
    private final long flags;

    private UcpAmData(UcpWorker worker, long address, long length, long flags) {
        this.worker = worker;
        this.address = address;
        this.length = length;
        this.flags = flags;
    }

    public String toString() {
        return "UcpAmData{address=" + Long.toHexString(this.address) + ", length=" + this.length + ", received=" + this.isDataValid() + '}';
    }

    public boolean isDataValid() {
        return (this.flags & UcpConstants.UCP_AM_RECV_ATTR_FLAG_RNDV) == 0L;
    }

    public boolean canPersist() {
        return (this.flags & UcpConstants.UCP_AM_RECV_ATTR_FLAG_DATA) != 0L;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getDataAddress() {
        if (!this.isDataValid()) {
            throw new UcxException("Data is not received yet.");
        }
        return this.address;
    }

    public long getLength() {
        return this.length;
    }

    public long getDataHandle() {
        return this.address;
    }

    public UcpRequest receive(long resultAddress, UcxCallback callback) {
        return this.worker.recvAmDataNonBlocking(this.getDataHandle(), resultAddress, this.length, callback, UcsConstants.MEMORY_TYPE.UCS_MEMORY_TYPE_UNKNOWN);
    }

    @Override
    public void close() throws IOException {
        if (this.isDataValid()) {
            this.worker.amDataRelease(this.address);
        }
    }
}

