/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class NativeLibs {
    private static final String UCM = "ucm";
    private static final String UCS = "ucs";
    private static final String UCT = "uct";
    private static final String UCP = "ucp";
    private static final String JUCX = "jucx";
    private static final ClassLoader loader = NativeLibs.class.getClassLoader();
    private static String errorMessage = null;
    static File tempDir;

    public static void load() {
        if (errorMessage != null) {
            throw new UnsatisfiedLinkError(errorMessage);
        }
    }

    private static void loadLibrary(String resourceName) {
        File file;
        URL url = loader.getResource(System.mapLibraryName(resourceName));
        if (url == null) {
            try {
                System.loadLibrary(resourceName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        try {
            file = NativeLibs.extractResource(url);
        }
        catch (IOException ex) {
            errorMessage = "Native code library failed to extract URL: " + url;
            return;
        }
        if (file != null && file.exists()) {
            String filename = file.getAbsolutePath();
            try {
                System.load(filename);
            }
            catch (UnsatisfiedLinkError ex) {
                errorMessage = "Native code library failed to load: " + file.getName() + ". " + ex.getLocalizedMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractResource(URL resourceURL) throws IOException {
        if (!resourceURL.getProtocol().equals("jar")) {
            return new File(resourceURL.getPath());
        }
        InputStream is = resourceURL.openStream();
        if (is == null) {
            errorMessage = "Error extracting native library content";
            return null;
        }
        try {
            NativeLibs.createTempDir();
        }
        catch (IOException ex) {
            errorMessage = "Failed to create temp directory";
            return null;
        }
        File file = new File(tempDir, new File(resourceURL.getPath()).getName());
        file.deleteOnExit();
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            NativeLibs.copy(is, os);
        }
        catch (Throwable throwable) {
            NativeLibs.closeQuietly(os);
            NativeLibs.closeQuietly(is);
            throw throwable;
        }
        NativeLibs.closeQuietly(os);
        NativeLibs.closeQuietly(is);
        return file;
    }

    private static void createTempDir() throws IOException {
        if (tempDir == null) {
            Path tmp = Files.createTempDirectory(JUCX, new FileAttribute[0]);
            tempDir = tmp.toFile();
            tempDir.deleteOnExit();
        }
    }

    private static void copy(InputStream is, OutputStream os) throws IOException {
        if (is == null || os == null) {
            return;
        }
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = is.read(buffer)) != -1) {
            os.write(buffer, 0, length);
        }
    }

    private static void closeQuietly(Closeable closable) {
        if (closable == null) {
            return;
        }
        try {
            closable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        NativeLibs.loadLibrary(UCM);
        NativeLibs.loadLibrary(UCS);
        NativeLibs.loadLibrary(UCT);
        NativeLibs.loadLibrary(UCP);
        NativeLibs.loadLibrary(JUCX);
        tempDir = null;
    }
}

