/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mobilitydata.gbfs.v2_3.free_bike_status.GBFSFreeBikeStatus;
import org.mobilitydata.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones;
import org.mobilitydata.gbfs.v2_3.station_information.GBFSStationInformation;
import org.mobilitydata.gbfs.v2_3.station_status.GBFSStation;
import org.mobilitydata.gbfs.v2_3.station_status.GBFSStationStatus;
import org.mobilitydata.gbfs.v2_3.system_information.GBFSSystemInformation;
import org.mobilitydata.gbfs.v2_3.vehicle_types.GBFSVehicleType;
import org.mobilitydata.gbfs.v2_3.vehicle_types.GBFSVehicleTypes;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.service.vehiclerental.model.GeofencingZone;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsFeedLoader;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsFreeVehicleStatusMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsGeofencingZoneMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsStationInformationMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsStationStatusMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsSystemInformationMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsVehicleTypeMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSource;
import org.opentripplanner.updater.vehicle_rental.datasources.params.GbfsVehicleRentalDataSourceParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.params.RentalPickupType;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GbfsVehicleRentalDataSource
implements VehicleRentalDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsVehicleRentalDataSource.class);
    private final GbfsVehicleRentalDataSourceParameters params;
    private final OtpHttpClient otpHttpClient;
    private GbfsFeedLoader loader;
    private List<GeofencingZone> geofencingZones = List.of();
    private boolean logGeofencingZonesDoesNotExistWarning = true;

    public GbfsVehicleRentalDataSource(GbfsVehicleRentalDataSourceParameters parameters, OtpHttpClientFactory otpHttpClientFactory) {
        this.params = parameters;
        this.otpHttpClient = otpHttpClientFactory.create(LOG);
    }

    @Override
    public boolean update() {
        if (this.loader == null) {
            return false;
        }
        return this.loader.update();
    }

    @Override
    public List<VehicleRentalPlace> getUpdates() {
        GBFSFreeBikeStatus freeBikeStatus;
        GBFSSystemInformation systemInformation = this.loader.getFeed(GBFSSystemInformation.class);
        GbfsSystemInformationMapper systemInformationMapper = new GbfsSystemInformationMapper();
        VehicleRentalSystem system = systemInformationMapper.mapSystemInformation(systemInformation.getData(), this.params.network());
        Map<String, RentalVehicleType> vehicleTypes = this.getVehicleTypes(system);
        LinkedList<VehicleRentalPlace> stations = new LinkedList<VehicleRentalPlace>();
        if (this.params.allowRentalType(RentalPickupType.STATION)) {
            GBFSStationInformation stationInformation = this.loader.getFeed(GBFSStationInformation.class);
            GBFSStationStatus stationStatus = this.loader.getFeed(GBFSStationStatus.class);
            if (stationInformation != null && stationStatus != null) {
                Map<String, GBFSStation> statusLookup = stationStatus.getData().getStations().stream().collect(Collectors.toMap(GBFSStation::getStationId, Function.identity()));
                GbfsStationStatusMapper stationStatusMapper = new GbfsStationStatusMapper(statusLookup, vehicleTypes);
                GbfsStationInformationMapper stationInformationMapper = new GbfsStationInformationMapper(system, vehicleTypes, this.params.allowKeepingRentedVehicleAtDestination(), this.params.overloadingAllowed());
                stations.addAll(stationInformation.getData().getStations().stream().map(stationInformationMapper::mapStationInformation).filter(Objects::nonNull).map(stationStatusMapper::mapStationStatus).toList());
            }
        }
        if (OTPFeature.FloatingBike.isOn() && this.params.allowRentalType(RentalPickupType.FREE_FLOATING) && (freeBikeStatus = this.loader.getFeed(GBFSFreeBikeStatus.class)) != null) {
            GbfsFreeVehicleStatusMapper freeVehicleStatusMapper = new GbfsFreeVehicleStatusMapper(system, vehicleTypes);
            stations.addAll(freeBikeStatus.getData().getBikes().stream().map(freeVehicleStatusMapper::mapFreeVehicleStatus).filter(Objects::nonNull).toList());
        }
        if (this.params.geofencingZones()) {
            GBFSGeofencingZones zones = this.loader.getFeed(GBFSGeofencingZones.class);
            if (zones != null) {
                GbfsGeofencingZoneMapper mapper = new GbfsGeofencingZoneMapper(system.systemId());
                this.geofencingZones = mapper.mapGeofencingZone(zones);
            } else {
                if (this.logGeofencingZonesDoesNotExistWarning) {
                    LOG.warn("GeofencingZones is enabled in OTP, but no zones exist for network: {}", (Object)this.params.network());
                }
                this.logGeofencingZonesDoesNotExistWarning = false;
            }
        }
        return stations;
    }

    @Override
    public void setup() {
        this.loader = new GbfsFeedLoader(this.params.url(), this.params.httpHeaders(), this.params.language(), this.otpHttpClient);
    }

    public String toString() {
        return ToStringBuilder.of(GbfsVehicleRentalDataSource.class).addStr("url", this.params.url()).addStr("language", this.params.language()).addBoolIfTrue("allowKeepingRentedVehicleAtDestination", Boolean.valueOf(this.params.allowKeepingRentedVehicleAtDestination())).toString();
    }

    @Override
    public List<GeofencingZone> getGeofencingZones() {
        return this.geofencingZones;
    }

    protected static Map<String, RentalVehicleType> mapVehicleTypes(GbfsVehicleTypeMapper vehicleTypeMapper, List<GBFSVehicleType> gbfsVehicleTypes) {
        return gbfsVehicleTypes.stream().map(vehicleTypeMapper::mapRentalVehicleType).distinct().collect(Collectors.toMap(v -> v.id().getId(), Function.identity()));
    }

    private Map<String, RentalVehicleType> getVehicleTypes(VehicleRentalSystem system) {
        GBFSVehicleTypes rawVehicleTypes = this.loader.getFeed(GBFSVehicleTypes.class);
        if (rawVehicleTypes != null) {
            GbfsVehicleTypeMapper vehicleTypeMapper = new GbfsVehicleTypeMapper(system.systemId());
            List gbfsVehicleTypes = rawVehicleTypes.getData().getVehicleTypes();
            return GbfsVehicleRentalDataSource.mapVehicleTypes(vehicleTypeMapper, gbfsVehicleTypes);
        }
        return Map.of();
    }
}

