/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import java.util.Map;
import java.util.stream.Collectors;
import org.mobilitydata.gbfs.v2_3.station_information.GBFSRentalUris;
import org.mobilitydata.gbfs.v2_3.station_information.GBFSStation;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationBuilder;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbfsStationInformationMapper {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsStationInformationMapper.class);
    private final VehicleRentalSystem system;
    private final Map<String, RentalVehicleType> vehicleTypes;
    private final boolean allowKeepingRentedVehicleAtDestination;
    private final boolean overloadingAllowed;

    public GbfsStationInformationMapper(VehicleRentalSystem system, Map<String, RentalVehicleType> vehicleTypes, boolean allowKeepingRentedVehicleAtDestination, boolean overloadingAllowed) {
        this.system = system;
        this.vehicleTypes = vehicleTypes;
        this.allowKeepingRentedVehicleAtDestination = allowKeepingRentedVehicleAtDestination;
        this.overloadingAllowed = overloadingAllowed;
    }

    public VehicleRentalStation mapStationInformation(GBFSStation station) {
        GBFSRentalUris rentalUris;
        if (station.getStationId() == null || station.getStationId().isBlank() || station.getName() == null || station.getName().isBlank() || station.getLon() == null || station.getLat() == null) {
            LOG.info(String.format("GBFS station for %s system has issues with required fields: \n%s", this.system.systemId(), station));
            return null;
        }
        VehicleRentalStationBuilder builder = VehicleRentalStation.of().withId(new FeedScopedId(this.system.systemId(), station.getStationId())).withSystem(this.system).withLongitude(station.getLon()).withLatitude(station.getLat()).withName(new NonLocalizedString(station.getName())).withShortName(NonLocalizedString.ofNullable(station.getShortName())).withCapacity(station.getCapacity() != null ? Integer.valueOf(station.getCapacity()) : null).withIsArrivingInRentalVehicleAtDestinationAllowed(this.allowKeepingRentedVehicleAtDestination).withOverloadingAllowed(this.overloadingAllowed);
        if (station.getVehicleCapacity() != null && this.vehicleTypes != null) {
            builder.withVehicleTypeAreaCapacity(station.getVehicleCapacity().getAdditionalProperties().entrySet().stream().collect(Collectors.toMap(e -> this.vehicleTypes.get(e.getKey()), e -> ((Double)e.getValue()).intValue())));
        }
        if (station.getVehicleTypeCapacity() != null && this.vehicleTypes != null) {
            builder.withVehicleTypeDockCapacity(station.getVehicleTypeCapacity().getAdditionalProperties().entrySet().stream().collect(Collectors.toMap(e -> this.vehicleTypes.get(e.getKey()), e -> ((Double)e.getValue()).intValue())));
        }
        if ((rentalUris = station.getRentalUris()) != null) {
            String androidUri = rentalUris.getAndroid();
            String iosUri = rentalUris.getIos();
            String webUri = rentalUris.getWeb();
            builder.withRentalUris(VehicleRentalStationUris.of().withAndroid(androidUri).withIos(iosUri).withWeb(webUri).build());
        }
        return builder.build();
    }
}

