/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.mobilitydata.gbfs.v2_3.free_bike_status.GBFSBike;
import org.mobilitydata.gbfs.v2_3.free_bike_status.GBFSRentalUris;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleFuel;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalVehicle;
import org.opentripplanner.transit.model.basic.Distance;
import org.opentripplanner.transit.model.basic.Ratio;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.lang.StringUtils;
import org.opentripplanner.utils.logging.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbfsFreeVehicleStatusMapper {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsFreeVehicleStatusMapper.class);
    private static final Throttle LOG_THROTTLE = Throttle.ofOneMinute();
    private final VehicleRentalSystem system;
    private final Map<String, RentalVehicleType> vehicleTypes;

    public GbfsFreeVehicleStatusMapper(VehicleRentalSystem system, @Nullable Map<String, RentalVehicleType> vehicleTypes) {
        this.system = system;
        this.vehicleTypes = new HashMap<String, RentalVehicleType>(Objects.requireNonNullElse(vehicleTypes, Map.of()));
    }

    public VehicleRentalVehicle mapFreeVehicleStatus(GBFSBike vehicle) {
        if ((vehicle.getStationId() == null || vehicle.getStationId().isBlank()) && vehicle.getLon() != null && vehicle.getLat() != null) {
            GBFSRentalUris rentalUris;
            Ratio fuelRatio = Ratio.ofBoxed(vehicle.getCurrentFuelPercent(), validationErrorMessage -> LOG_THROTTLE.throttle(() -> LOG.warn("'currentFuelPercent' is not valid. Details: {}", validationErrorMessage))).orElse(null);
            Distance rangeMeters = Distance.ofMetersBoxed(vehicle.getCurrentRangeMeters(), error -> LOG_THROTTLE.throttle(() -> LOG.warn("Current range meter value not valid: {} - {}", (Object)vehicle.getCurrentRangeMeters(), error))).orElse(null);
            if (vehicle.getVehicleTypeId() != null && this.vehicleTypes.get(vehicle.getVehicleTypeId()) != null && this.vehicleTypes.get(vehicle.getVehicleTypeId()).propulsionType() != RentalVehicleType.PropulsionType.HUMAN && rangeMeters == null) {
                return null;
            }
            VehicleRentalVehicle.Builder builder = VehicleRentalVehicle.of().withId(new FeedScopedId(this.system.systemId(), vehicle.getBikeId())).withSystem(this.system).withName(this.getName(vehicle)).withLongitude(vehicle.getLon()).withLatitude(vehicle.getLat()).withVehicleType(this.vehicleTypes.getOrDefault(vehicle.getVehicleTypeId(), RentalVehicleType.getDefaultType(this.system.systemId()))).withIsReserved(vehicle.getIsReserved() != null ? vehicle.getIsReserved() : false).withIsDisabled(vehicle.getIsDisabled() != null ? vehicle.getIsDisabled() : false).withFuel(RentalVehicleFuel.of().withPercent(fuelRatio).withRange(rangeMeters).build());
            String availableUntil = vehicle.getAvailableUntil();
            if (StringUtils.hasValue((String)availableUntil)) {
                builder.withAvailableUntil(OffsetDateTime.parse(availableUntil));
            }
            if ((rentalUris = vehicle.getRentalUris()) != null) {
                String androidUri = rentalUris.getAndroid();
                String iosUri = rentalUris.getIos();
                String webUri = rentalUris.getWeb();
                builder.withRentalUris(VehicleRentalStationUris.of().withAndroid(androidUri).withIos(iosUri).withWeb(webUri).build());
            }
            return builder.build();
        }
        return null;
    }

    private I18NString getName(GBFSBike vehicle) {
        RentalVehicleType type;
        String typeId = vehicle.getVehicleTypeId();
        if (typeId != null && (type = this.vehicleTypes.get(typeId)) != null && type.name() != null) {
            return type.name();
        }
        return RentalVehicleType.getDefaultType(this.system.systemId()).name();
    }
}

