/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.mobilitydata.gbfs.v2_3.gbfs.GBFS;
import org.mobilitydata.gbfs.v2_3.gbfs.GBFSFeed;
import org.mobilitydata.gbfs.v2_3.gbfs.GBFSFeedName;
import org.mobilitydata.gbfs.v2_3.gbfs.GBFSFeeds;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.spi.UpdaterConstructionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbfsFeedLoader {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsFeedLoader.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<GBFSFeedName, GBFSFeedUpdater<?>> feedUpdaters = new HashMap();
    private final HttpHeaders httpHeaders;
    private final OtpHttpClient otpHttpClient;

    public GbfsFeedLoader(String url, HttpHeaders httpHeaders, String languageCode, OtpHttpClient otpHttpClient) {
        GBFSFeeds feeds;
        URI uri;
        this.httpHeaders = httpHeaders;
        this.otpHttpClient = otpHttpClient;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new UpdaterConstructionException("Invalid url " + url);
        }
        GBFS data = this.fetchFeed(uri, httpHeaders, GBFS.class);
        if (data == null) {
            if (!url.endsWith("gbfs.json")) {
                LOG.warn("GBFS autoconfiguration url {} does not end with gbfs.json. Make sure it follows the specification, if you get any errors using it.", (Object)url);
            }
            throw new UpdaterConstructionException("Could not fetch the feed auto-configuration file from " + String.valueOf(uri));
        }
        GBFSFeeds gBFSFeeds = feeds = languageCode == null ? (GBFSFeeds)data.getFeedsData().values().iterator().next() : (GBFSFeeds)data.getFeedsData().get(languageCode);
        if (feeds == null) {
            throw new UpdaterConstructionException("Language " + languageCode + " does not exist in feed " + String.valueOf(uri));
        }
        for (GBFSFeed feed : feeds.getFeeds()) {
            GBFSFeedName feedName = feed.getName();
            if (this.feedUpdaters.containsKey(feedName)) {
                throw new UpdaterConstructionException("Feed contains duplicate url for feed " + String.valueOf(feedName) + ". Urls: " + String.valueOf(feed.getUrl()) + ", " + String.valueOf(this.feedUpdaters.get((Object)feedName).url));
            }
            if (feed.getName() == null) continue;
            this.feedUpdaters.put(feedName, new GBFSFeedUpdater(feed));
        }
    }

    GbfsFeedLoader(String url, HttpHeaders httpHeaders, String languageCode) {
        this(url, httpHeaders, languageCode, new OtpHttpClientFactory().create(LOG));
    }

    public boolean update() {
        boolean didUpdate = false;
        for (GBFSFeedUpdater<?> updater : this.feedUpdaters.values()) {
            if (!updater.shouldUpdate()) continue;
            boolean success = updater.fetchData();
            if (!success) {
                return false;
            }
            didUpdate = true;
        }
        return didUpdate;
    }

    public <T> T getFeed(Class<T> feed) {
        GBFSFeedUpdater<?> updater = this.feedUpdaters.get(GBFSFeedName.fromClass(feed));
        if (updater == null) {
            return null;
        }
        return feed.cast(updater.getData());
    }

    private <T> T fetchFeed(URI uri, HttpHeaders httpHeaders, Class<T> clazz) {
        try {
            return this.otpHttpClient.getAndMapAsJsonObject(uri, httpHeaders.asMap(), objectMapper, clazz);
        }
        catch (OtpHttpClientException e) {
            LOG.warn("Error parsing vehicle rental feed from {}. Details: {}.", new Object[]{uri, e.getMessage(), e});
            return null;
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
    }

    private class GBFSFeedUpdater<T> {
        private final URI url;
        private final Class<T> implementingClass;
        private int nextUpdate;
        private T data;

        private GBFSFeedUpdater(GBFSFeed feed) {
            this.url = feed.getUrl();
            this.implementingClass = feed.getName().implementingClass();
        }

        private T getData() {
            return this.data;
        }

        private boolean fetchData() {
            T newData = GbfsFeedLoader.this.fetchFeed(this.url, GbfsFeedLoader.this.httpHeaders, this.implementingClass);
            if (newData == null) {
                LOG.warn("Could not fetch GBFS data for {}. Retrying.", (Object)this.url);
                this.nextUpdate = this.getCurrentTimeSeconds();
                return false;
            }
            this.data = newData;
            try {
                Integer lastUpdated = (Integer)this.implementingClass.getMethod("getLastUpdated", new Class[0]).invoke(newData, new Object[0]);
                Integer ttl = (Integer)this.implementingClass.getMethod("getTtl", new Class[0]).invoke(newData, new Object[0]);
                this.nextUpdate = lastUpdated == null || ttl == null ? this.getCurrentTimeSeconds() : lastUpdated + ttl;
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error("Invalid lastUpdated or ttl for {}", (Object)this.url);
                this.nextUpdate = this.getCurrentTimeSeconds();
            }
            return true;
        }

        private boolean shouldUpdate() {
            return this.getCurrentTimeSeconds() >= this.nextUpdate;
        }

        private int getCurrentTimeSeconds() {
            return (int)(System.currentTimeMillis() / 1000L);
        }
    }
}

