/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.routing.linking.DisposableEdgeCollection;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.vehiclerental.model.GeofencingZone;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.street.StreetVehicleRentalLink;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalEdge;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.model.edge.LinkingDirection;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.VertexFactory;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.RealTimeUpdateContext;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.UpdaterConstructionException;
import org.opentripplanner.updater.vehicle_rental.GeofencingVertexUpdater;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSource;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.opentripplanner.utils.logging.Throttle;
import org.opentripplanner.utils.time.DurationUtils;
import org.opentripplanner.utils.time.TimeUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRentalUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleRentalUpdater.class);
    private final Throttle unlinkedPlaceThrottle;
    private final VehicleRentalDataSource source;
    private final String nameForLogging;
    private Map<StreetEdge, RentalRestrictionExtension> latestModifiedEdges = Map.of();
    private Set<GeofencingZone> latestAppliedGeofencingZones = Set.of();
    private final Map<FeedScopedId, VehicleRentalPlaceVertex> verticesByStation = new HashMap<FeedScopedId, VehicleRentalPlaceVertex>();
    private final Map<FeedScopedId, DisposableEdgeCollection> tempEdgesByStation = new HashMap<FeedScopedId, DisposableEdgeCollection>();
    private final VertexLinker linker;
    private final VehicleRentalRepository service;

    public VehicleRentalUpdater(VehicleRentalUpdaterParameters parameters, VehicleRentalDataSource source, VertexLinker vertexLinker, VehicleRentalRepository repository) throws IllegalArgumentException {
        super(parameters);
        LOG.info("Setting up vehicle rental updater for {}.", (Object)source);
        this.source = source;
        this.nameForLogging = (String)ObjectUtils.ifNotNull((Object)parameters.sourceParameters().network(), (Object)parameters.sourceParameters().url());
        this.unlinkedPlaceThrottle = Throttle.ofOneSecond();
        this.linker = vertexLinker;
        this.service = repository;
        try {
            source.setup();
        }
        catch (UpdaterConstructionException e) {
            LOG.warn("Unable to setup updater: {}", (Object)this.nameForLogging, (Object)e);
        }
        if (this.runOnlyOnce()) {
            LOG.info("Creating vehicle-rental updater running once only (non-polling): {}", (Object)this.nameForLogging);
        } else {
            LOG.info("Creating vehicle-rental updater running every {}: {}", (Object)DurationUtils.durationToStr((Duration)this.pollingPeriod()), (Object)this.nameForLogging);
        }
    }

    public String toString() {
        return ToStringBuilder.of(VehicleRentalUpdater.class).addObj("source", (Object)this.source).toString();
    }

    @Override
    public String getConfigRef() {
        return this.toString();
    }

    @Override
    protected void runPolling() throws InterruptedException, ExecutionException {
        LOG.debug("Updating vehicle rental stations from {}", (Object)this.nameForLogging);
        if (!this.source.update()) {
            LOG.debug("No updates from {}", (Object)this.nameForLogging);
            return;
        }
        List<VehicleRentalPlace> stations = this.source.getUpdates();
        List<GeofencingZone> geofencingZones = this.source.getGeofencingZones();
        VehicleRentalGraphWriterRunnable graphWriterRunnable = new VehicleRentalGraphWriterRunnable(stations, geofencingZones);
        this.updateGraph(graphWriterRunnable);
    }

    private class VehicleRentalGraphWriterRunnable
    implements GraphWriterRunnable {
        private final List<VehicleRentalPlace> stations;
        private final Set<GeofencingZone> geofencingZones;

        public VehicleRentalGraphWriterRunnable(List<VehicleRentalPlace> stations, List<GeofencingZone> geofencingZones) {
            this.stations = stations;
            this.geofencingZones = Set.copyOf(geofencingZones);
        }

        @Override
        public void run(RealTimeUpdateContext context) {
            HashSet<FeedScopedId> stationSet = new HashSet<FeedScopedId>();
            VertexFactory vertexFactory = new VertexFactory(context.graph());
            for (VehicleRentalPlace vehicleRentalPlace : this.stations) {
                VehicleRentalUpdater.this.service.addVehicleRentalStation(vehicleRentalPlace);
                stationSet.add(vehicleRentalPlace.id());
                VehicleRentalPlaceVertex vehicleRentalPlaceVertex = VehicleRentalUpdater.this.verticesByStation.get(vehicleRentalPlace.id());
                if (vehicleRentalPlaceVertex == null) {
                    VehicleRentalPlaceVertex vehicleRentalPlaceVertex2 = vertexFactory.vehicleRentalPlace(vehicleRentalPlace);
                    DisposableEdgeCollection tempEdges = VehicleRentalUpdater.this.linker.linkVertexForRealTime(vehicleRentalPlaceVertex2, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BIDIRECTIONAL, (vertex, streetVertex) -> List.of(StreetVehicleRentalLink.createStreetVehicleRentalLink((VehicleRentalPlaceVertex)vertex, streetVertex), StreetVehicleRentalLink.createStreetVehicleRentalLink(streetVertex, (VehicleRentalPlaceVertex)vertex)));
                    if (vehicleRentalPlaceVertex2.getOutgoing().isEmpty()) {
                        VehicleRentalPlaceVertex vrv = vehicleRentalPlaceVertex2;
                        VehicleRentalUpdater.this.unlinkedPlaceThrottle.throttle(() -> LOG.warn("VehicleRentalPlace is unlinked for {}: {}  {}", new Object[]{VehicleRentalUpdater.this.nameForLogging, vrv, VehicleRentalUpdater.this.unlinkedPlaceThrottle.setupInfo()}));
                    }
                    Set formFactors = Stream.concat(vehicleRentalPlace.availablePickupFormFactors(false).stream(), vehicleRentalPlace.availableDropoffFormFactors(false).stream()).collect(Collectors.toSet());
                    for (RentalFormFactor formFactor : formFactors) {
                        tempEdges.addEdge(VehicleRentalEdge.createVehicleRentalEdge(vehicleRentalPlaceVertex2, formFactor));
                    }
                    VehicleRentalUpdater.this.verticesByStation.put(vehicleRentalPlace.id(), vehicleRentalPlaceVertex2);
                    VehicleRentalUpdater.this.tempEdgesByStation.put(vehicleRentalPlace.id(), tempEdges);
                    continue;
                }
                vehicleRentalPlaceVertex.setStation(vehicleRentalPlace);
            }
            ArrayList<FeedScopedId> toRemove = new ArrayList<FeedScopedId>();
            for (Map.Entry<FeedScopedId, VehicleRentalPlaceVertex> entry : VehicleRentalUpdater.this.verticesByStation.entrySet()) {
                FeedScopedId station = entry.getKey();
                if (stationSet.contains(station)) continue;
                toRemove.add(station);
                VehicleRentalUpdater.this.service.removeVehicleRentalStation(station);
            }
            for (FeedScopedId feedScopedId : toRemove) {
                VehicleRentalUpdater.this.verticesByStation.remove(feedScopedId);
                VehicleRentalUpdater.this.tempEdgesByStation.get(feedScopedId).disposeEdges();
                VehicleRentalUpdater.this.tempEdgesByStation.remove(feedScopedId);
            }
            if (!this.geofencingZones.isEmpty() && !this.geofencingZones.equals(VehicleRentalUpdater.this.latestAppliedGeofencingZones)) {
                LOG.info("Computing geofencing zones for {}", (Object)VehicleRentalUpdater.this.nameForLogging);
                long l = System.currentTimeMillis();
                VehicleRentalUpdater.this.latestModifiedEdges.forEach(StreetEdge::removeRentalExtension);
                GeofencingVertexUpdater updater = new GeofencingVertexUpdater(context.graph()::findEdges);
                VehicleRentalUpdater.this.latestModifiedEdges = updater.applyGeofencingZones(this.geofencingZones);
                VehicleRentalUpdater.this.latestAppliedGeofencingZones = this.geofencingZones;
                long end = System.currentTimeMillis();
                Duration millis = Duration.ofMillis(end - l);
                LOG.info("Geofencing zones computation took {}. Added extension to {} edges. For {}", new Object[]{TimeUtils.durationToStrCompact((Duration)millis), VehicleRentalUpdater.this.latestModifiedEdges.size(), VehicleRentalUpdater.this.nameForLogging});
            }
        }
    }
}

