/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.service.vehiclerental.model.GeofencingZone;
import org.opentripplanner.service.vehiclerental.street.BusinessAreaBorder;
import org.opentripplanner.service.vehiclerental.street.GeofencingZoneExtension;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;

class GeofencingVertexUpdater {
    private final Function<Envelope, Collection<Edge>> getEdgesForEnvelope;

    public GeofencingVertexUpdater(Function<Envelope, Collection<Edge>> getEdgesForEnvelope) {
        this.getEdgesForEnvelope = getEdgesForEnvelope;
    }

    Map<StreetEdge, RentalRestrictionExtension> applyGeofencingZones(Collection<GeofencingZone> geofencingZones) {
        List<GeofencingZone> restrictedZones = geofencingZones.stream().filter(GeofencingZone::hasRestriction).toList();
        Map<StreetEdge, RentalRestrictionExtension> restrictedEdges = this.addExtensionToIntersectingStreetEdges(restrictedZones, GeofencingZoneExtension::new);
        HashMap<StreetEdge, RentalRestrictionExtension> updates = new HashMap<StreetEdge, RentalRestrictionExtension>(restrictedEdges);
        List<GeofencingZone> generalBusinessAreas = geofencingZones.stream().filter(GeofencingZone::isBusinessArea).toList();
        if (!generalBusinessAreas.isEmpty()) {
            String network = generalBusinessAreas.get(0).id().getFeedId();
            Geometry[] polygons = (Geometry[])generalBusinessAreas.stream().map(GeofencingZone::geometry).toArray(Geometry[]::new);
            Geometry unionOfBusinessAreas = GeometryUtils.getGeometryFactory().createGeometryCollection(polygons).union();
            Map<StreetEdge, RentalRestrictionExtension> updated = this.applyExtension(unionOfBusinessAreas.getBoundary(), new BusinessAreaBorder(network));
            updates.putAll(updated);
        }
        return Map.copyOf(updates);
    }

    private Map<StreetEdge, RentalRestrictionExtension> addExtensionToIntersectingStreetEdges(List<GeofencingZone> zones, Function<GeofencingZone, RentalRestrictionExtension> createExtension) {
        HashMap<StreetEdge, RentalRestrictionExtension> edgesUpdated = new HashMap<StreetEdge, RentalRestrictionExtension>();
        for (GeofencingZone zone : zones) {
            Geometry geom = zone.geometry();
            RentalRestrictionExtension ext = createExtension.apply(zone);
            edgesUpdated.putAll(this.applyExtension(geom, ext));
        }
        return edgesUpdated;
    }

    private Map<StreetEdge, RentalRestrictionExtension> applyExtension(Geometry geom, RentalRestrictionExtension ext) {
        Set<Edge> candidates;
        HashMap<StreetEdge, RentalRestrictionExtension> edgesUpdated = new HashMap<StreetEdge, RentalRestrictionExtension>();
        if (geom instanceof LineString) {
            LineString ring = (LineString)geom;
            candidates = this.getEdgesAlongLineStrings(List.of(ring));
        } else if (geom instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)geom;
            List<LineString> lineStrings = GeometryUtils.getLineStrings(mls);
            candidates = this.getEdgesAlongLineStrings(lineStrings);
        } else {
            candidates = Set.copyOf(this.getEdgesForEnvelope.apply(geom.getEnvelopeInternal()));
        }
        for (Edge e : candidates) {
            StreetEdge streetEdge;
            if (!(e instanceof StreetEdge) || !(streetEdge = (StreetEdge)e).getGeometry().intersects(geom)) continue;
            streetEdge.addRentalRestriction(ext);
            edgesUpdated.put(streetEdge, ext);
        }
        return edgesUpdated;
    }

    private Set<Edge> getEdgesAlongLineStrings(Collection<LineString> lineStrings) {
        return lineStrings.stream().flatMap(GeometryUtils::toEnvelopes).map(this.getEdgesForEnvelope).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

