/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_position;

import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleRepository;
import org.opentripplanner.standalone.config.routerconfig.updaters.VehiclePositionsUpdaterConfig;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.RealTimeUpdateContext;
import org.opentripplanner.updater.vehicle_position.RealtimeVehiclePatternMatcher;

class VehiclePositionUpdaterRunnable
implements GraphWriterRunnable {
    private final List<GtfsRealtime.VehiclePosition> updates;
    private final RealtimeVehicleRepository realtimeVehicleRepository;
    private final String feedId;
    private final boolean fuzzyTripMatching;
    private final Set<VehiclePositionsUpdaterConfig.VehiclePositionFeature> vehiclePositionFeatures;

    public VehiclePositionUpdaterRunnable(RealtimeVehicleRepository realtimeVehicleRepository, Set<VehiclePositionsUpdaterConfig.VehiclePositionFeature> vehiclePositionFeatures, String feedId, boolean fuzzyTripMatching, List<GtfsRealtime.VehiclePosition> updates) {
        this.updates = Objects.requireNonNull(updates);
        this.feedId = feedId;
        this.realtimeVehicleRepository = realtimeVehicleRepository;
        this.fuzzyTripMatching = fuzzyTripMatching;
        this.vehiclePositionFeatures = vehiclePositionFeatures;
    }

    @Override
    public void run(RealTimeUpdateContext context) {
        RealtimeVehiclePatternMatcher matcher = new RealtimeVehiclePatternMatcher(this.feedId, context.transitService()::getTrip, context.transitService()::findPattern, context.transitService()::findPattern, this.realtimeVehicleRepository, context.transitService().getTimeZone(), this.fuzzyTripMatching ? context.gtfsRealtimeFuzzyTripMatcher() : null, this.vehiclePositionFeatures);
        matcher.applyRealtimeVehicleUpdates(this.updates);
    }
}

