/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_position;

import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import java.util.Set;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleRepository;
import org.opentripplanner.standalone.config.routerconfig.updaters.VehiclePositionsUpdaterConfig;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.vehicle_position.GtfsRealtimeHttpVehiclePositionSource;
import org.opentripplanner.updater.vehicle_position.VehiclePositionUpdaterRunnable;
import org.opentripplanner.updater.vehicle_position.VehiclePositionsUpdaterParameters;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingVehiclePositionUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PollingVehiclePositionUpdater.class);
    private final GtfsRealtimeHttpVehiclePositionSource vehiclePositionSource;
    private final Set<VehiclePositionsUpdaterConfig.VehiclePositionFeature> vehiclePositionFeatures;
    private final String feedId;
    private final RealtimeVehicleRepository realtimeVehicleRepository;
    private final boolean fuzzyTripMatching;

    public PollingVehiclePositionUpdater(VehiclePositionsUpdaterParameters params, RealtimeVehicleRepository realtimeVehicleRepository) {
        super(params);
        this.vehiclePositionSource = new GtfsRealtimeHttpVehiclePositionSource(params.url(), params.headers());
        this.realtimeVehicleRepository = realtimeVehicleRepository;
        this.feedId = params.feedId();
        this.fuzzyTripMatching = params.fuzzyTripMatching();
        this.vehiclePositionFeatures = params.vehiclePositionFeatures();
        LOG.info("Creating vehicle position updater running every {}: {}", (Object)this.pollingPeriod(), (Object)this.vehiclePositionSource);
    }

    @Override
    public void runPolling() {
        List<GtfsRealtime.VehiclePosition> updates = this.vehiclePositionSource.getPositions();
        VehiclePositionUpdaterRunnable runnable = new VehiclePositionUpdaterRunnable(this.realtimeVehicleRepository, this.vehiclePositionFeatures, this.feedId, this.fuzzyTripMatching, updates);
        this.updateGraph(runnable);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("source", (Object)this.vehiclePositionSource).toString();
    }
}

