/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_position;

import com.google.transit.realtime.GtfsRealtime;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GtfsRealtimeHttpVehiclePositionSource {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeHttpVehiclePositionSource.class);
    private final URI url;
    private final HttpHeaders headers;
    private final OtpHttpClient otpHttpClient;

    public GtfsRealtimeHttpVehiclePositionSource(URI url, HttpHeaders headers) {
        this.url = url;
        this.headers = HttpHeaders.of().acceptProtobuf().add(headers).build();
        this.otpHttpClient = new OtpHttpClientFactory().create(LOG);
    }

    public List<GtfsRealtime.VehiclePosition> getPositions() {
        try {
            return this.otpHttpClient.getAndMap(this.url, this.headers.asMap(), this::getPositions);
        }
        catch (OtpHttpClientException e) {
            LOG.warn("Error reading vehicle positions from {}", (Object)this.url, (Object)e);
            return List.of();
        }
    }

    public String toString() {
        return ToStringBuilder.of(GtfsRealtimeHttpVehiclePositionSource.class).addObj("url", (Object)this.url).toString();
    }

    private List<GtfsRealtime.VehiclePosition> getPositions(InputStream is) throws IOException {
        ArrayList<GtfsRealtime.VehiclePosition> positions = null;
        if (is != null) {
            GtfsRealtime.FeedMessage feedMessage = GtfsRealtime.FeedMessage.parseFrom((InputStream)is);
            List feedEntityList = feedMessage.getEntityList();
            positions = new ArrayList<GtfsRealtime.VehiclePosition>(feedEntityList.size());
            for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                if (!feedEntity.hasVehicle()) continue;
                positions.add(feedEntity.getVehicle());
            }
        }
        return positions;
    }
}

