/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_parking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.DisposableEdgeCollection;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingHelper;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingState;
import org.opentripplanner.street.model.edge.LinkingDirection;
import org.opentripplanner.street.model.edge.StreetVehicleParkingLink;
import org.opentripplanner.street.model.edge.VehicleParkingEdge;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.RealTimeUpdateContext;
import org.opentripplanner.updater.spi.DataSource;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdaterParameters;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleParkingUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleParkingUpdater.class);
    private final Map<VehicleParking, List<VehicleParkingEntranceVertex>> verticesByPark = new HashMap<VehicleParking, List<VehicleParkingEntranceVertex>>();
    private final Map<VehicleParking, List<DisposableEdgeCollection>> tempEdgesByPark = new HashMap<VehicleParking, List<DisposableEdgeCollection>>();
    private final DataSource<VehicleParking> source;
    private final List<VehicleParking> oldVehicleParkings = new ArrayList<VehicleParking>();
    private final VertexLinker linker;
    private final VehicleParkingRepository parkingRepository;

    public VehicleParkingUpdater(VehicleParkingUpdaterParameters parameters, DataSource<VehicleParking> source, VertexLinker vertexLinker, VehicleParkingRepository parkingRepository) {
        super(parameters);
        this.source = source;
        this.linker = vertexLinker;
        this.parkingRepository = parkingRepository;
        LOG.info("Creating vehicle-parking updater running every {}: {}", (Object)this.pollingPeriod(), source);
    }

    @Override
    protected void runPolling() throws InterruptedException, ExecutionException {
        LOG.debug("Updating vehicle parkings from {}", this.source);
        if (!this.source.update()) {
            LOG.debug("No updates");
            return;
        }
        List<VehicleParking> vehicleParkings = this.source.getUpdates();
        VehicleParkingGraphWriterRunnable graphWriterRunnable = new VehicleParkingGraphWriterRunnable(vehicleParkings);
        this.updateGraph(graphWriterRunnable);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("source", this.source).toString();
    }

    private class VehicleParkingGraphWriterRunnable
    implements GraphWriterRunnable {
        private final Map<FeedScopedId, VehicleParking> oldVehicleParkingsById;
        private final Set<VehicleParking> updatedVehicleParkings;

        private VehicleParkingGraphWriterRunnable(List<VehicleParking> updatedVehicleParkings) {
            this.oldVehicleParkingsById = VehicleParkingUpdater.this.oldVehicleParkings.stream().collect(Collectors.toMap(VehicleParking::getId, Function.identity()));
            this.updatedVehicleParkings = new HashSet<VehicleParking>(updatedVehicleParkings);
        }

        @Override
        public void run(RealTimeUpdateContext context) {
            HashSet<VehicleParking> toAdd = new HashSet<VehicleParking>();
            HashSet<VehicleParking> toLink = new HashSet<VehicleParking>();
            HashSet<VehicleParking> toRemove = new HashSet<VehicleParking>();
            VehicleParkingHelper vehicleParkingHelper = new VehicleParkingHelper(context.graph());
            for (VehicleParking updatedVehicleParking : this.updatedVehicleParkings) {
                boolean operational = updatedVehicleParking.getState().equals((Object)VehicleParkingState.OPERATIONAL);
                boolean alreadyExists = VehicleParkingUpdater.this.oldVehicleParkings.contains(updatedVehicleParking);
                if (alreadyExists) {
                    this.oldVehicleParkingsById.get(updatedVehicleParking.getId()).updateAvailability(updatedVehicleParking.getAvailability());
                    continue;
                }
                toAdd.add(updatedVehicleParking);
                if (!operational) continue;
                toLink.add(updatedVehicleParking);
            }
            for (VehicleParking oldVehicleParking : VehicleParkingUpdater.this.oldVehicleParkings) {
                if (this.updatedVehicleParkings.contains(oldVehicleParking)) continue;
                if (VehicleParkingUpdater.this.verticesByPark.containsKey(oldVehicleParking)) {
                    VehicleParkingUpdater.this.tempEdgesByPark.get(oldVehicleParking).forEach(DisposableEdgeCollection::disposeEdges);
                    VehicleParkingUpdater.this.verticesByPark.get(oldVehicleParking).forEach(v -> this.removeVehicleParkingEdgesFromGraph((VehicleParkingEntranceVertex)v, context.graph()));
                    VehicleParkingUpdater.this.verticesByPark.remove(oldVehicleParking);
                }
                toRemove.add(oldVehicleParking);
            }
            for (VehicleParking updatedVehicleParking : toLink) {
                List<VehicleParkingEntranceVertex> vehicleParkingVertices = vehicleParkingHelper.createVehicleParkingVertices(updatedVehicleParking);
                List<DisposableEdgeCollection> disposableEdgeCollectionsForVertex = this.linkVehicleParkingVertexToStreets(vehicleParkingVertices);
                VehicleParkingHelper.linkVehicleParkingEntrances(vehicleParkingVertices);
                VehicleParkingUpdater.this.verticesByPark.put(updatedVehicleParking, vehicleParkingVertices);
                VehicleParkingUpdater.this.tempEdgesByPark.put(updatedVehicleParking, disposableEdgeCollectionsForVertex);
            }
            VehicleParkingUpdater.this.parkingRepository.updateVehicleParking(toAdd, toRemove);
            VehicleParkingUpdater.this.oldVehicleParkings.removeAll(toRemove);
            VehicleParkingUpdater.this.oldVehicleParkings.addAll(toAdd);
        }

        private List<DisposableEdgeCollection> linkVehicleParkingVertexToStreets(List<VehicleParkingEntranceVertex> vehicleParkingVertices) {
            ArrayList<DisposableEdgeCollection> disposableEdgeCollectionsForVertex = new ArrayList<DisposableEdgeCollection>();
            for (VehicleParkingEntranceVertex vehicleParkingVertex : vehicleParkingVertices) {
                List<DisposableEdgeCollection> disposableEdges = this.linkVehicleParkingForRealtime(vehicleParkingVertex);
                disposableEdgeCollectionsForVertex.addAll(disposableEdges);
                if (!vehicleParkingVertex.getOutgoing().isEmpty()) continue;
                LOG.info("Vehicle parking {} unlinked", (Object)vehicleParkingVertex);
            }
            return disposableEdgeCollectionsForVertex;
        }

        private List<DisposableEdgeCollection> linkVehicleParkingForRealtime(VehicleParkingEntranceVertex vehicleParkingEntranceVertex) {
            ArrayList<DisposableEdgeCollection> disposableEdgeCollections = new ArrayList<DisposableEdgeCollection>();
            if (vehicleParkingEntranceVertex.isWalkAccessible()) {
                DisposableEdgeCollection disposableWalkEdges = VehicleParkingUpdater.this.linker.linkVertexForRealTime(vehicleParkingEntranceVertex, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BIDIRECTIONAL, (vertex, streetVertex) -> List.of(StreetVehicleParkingLink.createStreetVehicleParkingLink((VehicleParkingEntranceVertex)vertex, streetVertex), StreetVehicleParkingLink.createStreetVehicleParkingLink(streetVertex, (VehicleParkingEntranceVertex)vertex)));
                disposableEdgeCollections.add(disposableWalkEdges);
            }
            if (vehicleParkingEntranceVertex.isCarAccessible()) {
                DisposableEdgeCollection disposableCarEdges = VehicleParkingUpdater.this.linker.linkVertexForRealTime(vehicleParkingEntranceVertex, new TraverseModeSet(TraverseMode.CAR), LinkingDirection.BIDIRECTIONAL, (vertex, streetVertex) -> List.of(StreetVehicleParkingLink.createStreetVehicleParkingLink((VehicleParkingEntranceVertex)vertex, streetVertex), StreetVehicleParkingLink.createStreetVehicleParkingLink(streetVertex, (VehicleParkingEntranceVertex)vertex)));
                disposableEdgeCollections.add(disposableCarEdges);
            }
            return disposableEdgeCollections;
        }

        private void removeVehicleParkingEdgesFromGraph(VehicleParkingEntranceVertex entranceVertex, Graph graph) {
            entranceVertex.getIncoming().stream().filter(VehicleParkingEdge.class::isInstance).forEach(graph::removeEdge);
            entranceVertex.getOutgoing().stream().filter(VehicleParkingEdge.class::isInstance).forEach(graph::removeEdge);
            graph.remove(entranceVertex);
        }
    }
}

