/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_parking;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingSpaces;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.RealTimeUpdateContext;
import org.opentripplanner.updater.spi.DataSource;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.vehicle_parking.AvailabiltyUpdate;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdaterParameters;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleParkingAvailabilityUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleParkingAvailabilityUpdater.class);
    private final DataSource<AvailabiltyUpdate> source;
    private final VehicleParkingRepository repository;

    public VehicleParkingAvailabilityUpdater(VehicleParkingUpdaterParameters parameters, DataSource<AvailabiltyUpdate> source, VehicleParkingRepository parkingRepository) {
        super(parameters);
        this.source = source;
        this.repository = parkingRepository;
        LOG.info("Creating vehicle-parking updater running every {}: {}", (Object)this.pollingPeriod(), source);
    }

    @Override
    protected void runPolling() throws InterruptedException, ExecutionException {
        if (this.source.update()) {
            List<AvailabiltyUpdate> updates = this.source.getUpdates();
            AvailabilityUpdater graphWriterRunnable = new AvailabilityUpdater(this, updates);
            this.updateGraph(graphWriterRunnable);
        }
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("source", this.source).toString();
    }

    private class AvailabilityUpdater
    implements GraphWriterRunnable {
        private final List<AvailabiltyUpdate> updates;
        private final Map<FeedScopedId, VehicleParking> parkingById;

        private AvailabilityUpdater(VehicleParkingAvailabilityUpdater vehicleParkingAvailabilityUpdater, List<AvailabiltyUpdate> updates) {
            this.updates = List.copyOf(updates);
            this.parkingById = vehicleParkingAvailabilityUpdater.repository.listVehicleParkings().stream().collect(Collectors.toUnmodifiableMap(VehicleParking::getId, Function.identity()));
        }

        @Override
        public void run(RealTimeUpdateContext context) {
            this.updates.forEach(this::handleUpdate);
        }

        private void handleUpdate(AvailabiltyUpdate update) {
            if (!this.parkingById.containsKey(update.vehicleParkingId())) {
                LOG.warn("Parking with id {} does not exist. Skipping availability update.", (Object)update.vehicleParkingId());
            } else {
                VehicleParking parking = this.parkingById.get(update.vehicleParkingId());
                VehicleParkingSpaces.VehicleParkingSpacesBuilder builder = VehicleParkingSpaces.builder();
                if (parking.hasCarPlaces()) {
                    builder.carSpaces(update.spacesAvailable());
                }
                if (parking.hasBicyclePlaces()) {
                    builder.bicycleSpaces(update.spacesAvailable());
                }
                parking.updateAvailability(builder.build());
            }
        }
    }
}

