/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri.updater.google;

import java.util.function.Consumer;
import org.opentripplanner.updater.spi.GraphUpdater;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;
import org.opentripplanner.updater.trip.siri.SiriRealTimeTripUpdateAdapter;
import org.opentripplanner.updater.trip.siri.updater.AsyncEstimatedTimetableProcessor;
import org.opentripplanner.updater.trip.siri.updater.AsyncEstimatedTimetableSource;
import org.opentripplanner.updater.trip.siri.updater.EstimatedTimetableHandler;
import org.opentripplanner.updater.trip.siri.updater.google.GooglePubsubEstimatedTimetableSource;
import org.opentripplanner.updater.trip.siri.updater.google.SiriETGooglePubsubUpdaterParameters;

public class SiriETGooglePubsubUpdater
implements GraphUpdater {
    private final String configRef;
    private final AsyncEstimatedTimetableSource asyncEstimatedTimetableSource;
    private final EstimatedTimetableHandler estimatedTimetableHandler;
    private final Consumer<UpdateResult> updateResultConsumer;
    private WriteToGraphCallback saveResultOnGraph;

    public SiriETGooglePubsubUpdater(SiriETGooglePubsubUpdaterParameters config, SiriRealTimeTripUpdateAdapter adapter) {
        this.configRef = config.configRef();
        this.asyncEstimatedTimetableSource = new GooglePubsubEstimatedTimetableSource(config.dataInitializationUrl(), config.reconnectPeriod(), config.initialGetDataTimeout(), config.subscriptionProjectName(), config.topicProjectName(), config.topicName());
        this.estimatedTimetableHandler = new EstimatedTimetableHandler(adapter, config.fuzzyTripMatching(), config.feedId());
        this.updateResultConsumer = TripUpdateMetrics.streaming(config);
    }

    @Override
    public void setup(WriteToGraphCallback writeToGraphCallback) {
        this.saveResultOnGraph = writeToGraphCallback;
    }

    @Override
    public void run() {
        AsyncEstimatedTimetableProcessor asyncEstimatedTimetableProcessor = new AsyncEstimatedTimetableProcessor(this.estimatedTimetableHandler, this.saveResultOnGraph, this.updateResultConsumer);
        this.asyncEstimatedTimetableSource.start(asyncEstimatedTimetableProcessor::processSiriData);
    }

    @Override
    public boolean isPrimed() {
        return this.asyncEstimatedTimetableSource.isPrimed();
    }

    @Override
    public String getConfigRef() {
        return this.configRef;
    }
}

