/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri.updater;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.PollingGraphUpdaterParameters;
import org.opentripplanner.updater.spi.ResultLogger;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.trip.UpdateIncrementality;
import org.opentripplanner.updater.trip.UrlUpdaterParameters;
import org.opentripplanner.updater.trip.siri.SiriRealTimeTripUpdateAdapter;
import org.opentripplanner.updater.trip.siri.updater.EstimatedTimetableHandler;
import org.opentripplanner.updater.trip.siri.updater.EstimatedTimetableSource;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.ServiceDelivery;
import uk.org.siri.siri21.Siri;

public class SiriETUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(SiriETUpdater.class);
    private final EstimatedTimetableSource updateSource;
    private final String feedId;
    private final EstimatedTimetableHandler estimatedTimetableHandler;
    private final Consumer<UpdateResult> metricsConsumer;

    public SiriETUpdater(Parameters config, SiriRealTimeTripUpdateAdapter adapter, EstimatedTimetableSource source, Consumer<UpdateResult> metricsConsumer) {
        super(config);
        this.feedId = config.feedId();
        this.updateSource = source;
        this.blockReadinessUntilInitialized = config.blockReadinessUntilInitialized();
        LOG.info("Creating SIRI-ET updater running every {}: {}", (Object)this.pollingPeriod(), (Object)this.updateSource);
        this.estimatedTimetableHandler = new EstimatedTimetableHandler(adapter, config.fuzzyTripMatching(), this.feedId);
        this.metricsConsumer = metricsConsumer;
    }

    @Override
    public void runPolling() {
        boolean moreData = false;
        do {
            Optional<Siri> updates;
            if (!(updates = this.updateSource.getUpdates()).isPresent()) continue;
            UpdateIncrementality incrementality = this.updateSource.incrementalityOfLastUpdates();
            ServiceDelivery serviceDelivery = updates.get().getServiceDelivery();
            moreData = Boolean.TRUE.equals(serviceDelivery.isMoreData());
            boolean markPrimed = !moreData;
            List etds = serviceDelivery.getEstimatedTimetableDeliveries();
            if (etds == null) continue;
            this.updateGraph(context -> {
                UpdateResult result = this.estimatedTimetableHandler.applyUpdate(etds, incrementality, context);
                ResultLogger.logUpdateResult(this.feedId, "siri-et", result);
                this.metricsConsumer.accept(result);
                if (markPrimed) {
                    this.primed = true;
                }
            });
        } while (moreData);
    }

    public String toString() {
        return ToStringBuilder.of(SiriETUpdater.class).addStr("source", this.updateSource.toString()).addDuration("frequency", this.pollingPeriod()).toString();
    }

    public static interface Parameters
    extends UrlUpdaterParameters,
    PollingGraphUpdaterParameters {
        @Override
        public String url();

        public boolean blockReadinessUntilInitialized();

        public boolean fuzzyTripMatching();
    }
}

