/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri.updater;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.support.siri.SiriLoader;
import org.opentripplanner.updater.trip.UpdateIncrementality;
import org.opentripplanner.updater.trip.siri.updater.EstimatedTimetableSource;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.ServiceDelivery;
import uk.org.siri.siri21.Siri;

public class SiriETHttpTripUpdateSource
implements EstimatedTimetableSource {
    private static final Logger LOG = LoggerFactory.getLogger(SiriETHttpTripUpdateSource.class);
    private final String url;
    private final SiriLoader siriLoader;
    private final String requestorRef;
    private UpdateIncrementality updateIncrementality = UpdateIncrementality.FULL_DATASET;
    private ZonedDateTime lastTimestamp = ZonedDateTime.now().minusMonths(1L);

    public SiriETHttpTripUpdateSource(Parameters parameters, SiriLoader siriLoader) {
        this.url = parameters.url();
        this.requestorRef = parameters.requestorRef() == null || parameters.requestorRef().isEmpty() ? "otp-" + String.valueOf(UUID.randomUUID()) : parameters.requestorRef();
        this.siriLoader = siriLoader;
    }

    @Override
    public Optional<Siri> getUpdates() {
        long t1 = System.currentTimeMillis();
        try {
            Optional<Siri> siri = this.siriLoader.fetchETFeed(this.requestorRef);
            if (siri.map(Siri::getServiceDelivery).isEmpty()) {
                return Optional.empty();
            }
            ServiceDelivery serviceDelivery = siri.get().getServiceDelivery();
            if (serviceDelivery.getResponseTimestamp().isBefore(this.lastTimestamp)) {
                LOG.info("Newer data has already been processed");
                return Optional.empty();
            }
            this.lastTimestamp = serviceDelivery.getResponseTimestamp();
            this.updateIncrementality = UpdateIncrementality.DIFFERENTIAL;
            return siri;
        }
        catch (OtpHttpClientException e) {
            LOG.info("Failed after {} ms", (Object)(System.currentTimeMillis() - t1));
            LOG.warn("Could not get SIRI-ET data from {}", (Object)this.url, (Object)e);
        }
        catch (Exception e) {
            LOG.info("Failed after {} ms", (Object)(System.currentTimeMillis() - t1));
            LOG.warn("Failed to parse SIRI-ET feed from {}", (Object)this.url, (Object)e);
        }
        return Optional.empty();
    }

    @Override
    public UpdateIncrementality incrementalityOfLastUpdates() {
        return this.updateIncrementality;
    }

    public String toString() {
        return ToStringBuilder.of(SiriETHttpTripUpdateSource.class).addStr("url", this.url).toString();
    }

    public static interface Parameters {
        public String url();

        public String requestorRef();

        public String feedId();

        public Duration timeout();

        @Nullable
        public Duration previewInterval();

        public HttpHeaders httpRequestHeaders();
    }
}

