/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri.updater;

import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.opentripplanner.updater.trip.UpdateIncrementality;
import org.opentripplanner.updater.trip.siri.updater.EstimatedTimetableHandler;
import uk.org.siri.siri21.ServiceDelivery;

public class AsyncEstimatedTimetableProcessor {
    private final EstimatedTimetableHandler estimatedTimetableHandler;
    private final WriteToGraphCallback saveResultOnGraph;
    private final Consumer<UpdateResult> updateResultConsumer;

    public AsyncEstimatedTimetableProcessor(EstimatedTimetableHandler estimatedTimetableHandler, WriteToGraphCallback saveResultOnGraph, Consumer<UpdateResult> updateResultConsumer) {
        this.estimatedTimetableHandler = estimatedTimetableHandler;
        this.saveResultOnGraph = saveResultOnGraph;
        this.updateResultConsumer = updateResultConsumer;
    }

    public Future<?> processSiriData(ServiceDelivery serviceDelivery) {
        return this.saveResultOnGraph.execute(context -> this.updateResultConsumer.accept(this.estimatedTimetableHandler.applyUpdate(serviceDelivery.getEstimatedTimetableDeliveries(), UpdateIncrementality.DIFFERENTIAL, context)));
    }
}

