/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri.mapping;

import java.util.Optional;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import uk.org.siri.siri21.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri21.CallStatusEnumeration;
import uk.org.siri.siri21.DepartureBoardingActivityEnumeration;

public class PickDropMapper {
    public static Optional<PickDrop> mapDropOffType(CallWrapper call, PickDrop plannedValue) {
        if (PickDropMapper.shouldBeCancelled(plannedValue, call.isCancellation(), call.getArrivalStatus())) {
            return Optional.of(PickDrop.CANCELLED);
        }
        ArrivalBoardingActivityEnumeration arrivalBoardingActivityEnumeration = call.getArrivalBoardingActivity();
        if (arrivalBoardingActivityEnumeration == null) {
            return Optional.empty();
        }
        return switch (arrivalBoardingActivityEnumeration) {
            default -> throw new MatchException(null, null);
            case ArrivalBoardingActivityEnumeration.ALIGHTING -> {
                if (plannedValue.isNotRoutable()) {
                    yield Optional.of(PickDrop.SCHEDULED);
                }
                yield Optional.empty();
            }
            case ArrivalBoardingActivityEnumeration.NO_ALIGHTING -> Optional.of(PickDrop.NONE);
            case ArrivalBoardingActivityEnumeration.PASS_THRU -> Optional.of(PickDrop.CANCELLED);
        };
    }

    public static Optional<PickDrop> mapPickUpType(CallWrapper call, PickDrop plannedValue) {
        if (PickDropMapper.shouldBeCancelled(plannedValue, call.isCancellation(), call.getDepartureStatus())) {
            return Optional.of(PickDrop.CANCELLED);
        }
        DepartureBoardingActivityEnumeration departureBoardingActivityEnumeration = call.getDepartureBoardingActivity();
        if (departureBoardingActivityEnumeration == null) {
            return Optional.empty();
        }
        return switch (departureBoardingActivityEnumeration) {
            default -> throw new MatchException(null, null);
            case DepartureBoardingActivityEnumeration.BOARDING -> {
                if (plannedValue.isNotRoutable()) {
                    yield Optional.of(PickDrop.SCHEDULED);
                }
                yield Optional.empty();
            }
            case DepartureBoardingActivityEnumeration.NO_BOARDING -> Optional.of(PickDrop.NONE);
            case DepartureBoardingActivityEnumeration.PASS_THRU -> Optional.of(PickDrop.CANCELLED);
        };
    }

    private static boolean shouldBeCancelled(PickDrop plannedValue, Boolean isCallCancellation, CallStatusEnumeration callStatus) {
        if (plannedValue.isNotRoutable()) {
            return false;
        }
        return Boolean.TRUE.equals(isCallCancellation) || callStatus == CallStatusEnumeration.CANCELLED;
    }
}

