/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri.mapping;

import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import uk.org.siri.siri21.OccupancyEnumeration;

public class OccupancyMapper {
    public static OccupancyStatus mapOccupancyStatus(OccupancyEnumeration occupancy) {
        if (occupancy == null) {
            return OccupancyStatus.NO_DATA_AVAILABLE;
        }
        return switch (occupancy) {
            default -> throw new MatchException(null, null);
            case OccupancyEnumeration.EMPTY -> OccupancyStatus.EMPTY;
            case OccupancyEnumeration.SEATS_AVAILABLE, OccupancyEnumeration.MANY_SEATS_AVAILABLE -> OccupancyStatus.MANY_SEATS_AVAILABLE;
            case OccupancyEnumeration.FEW_SEATS_AVAILABLE -> OccupancyStatus.FEW_SEATS_AVAILABLE;
            case OccupancyEnumeration.STANDING_AVAILABLE -> OccupancyStatus.STANDING_ROOM_ONLY;
            case OccupancyEnumeration.STANDING_ROOM_ONLY -> OccupancyStatus.STANDING_ROOM_ONLY;
            case OccupancyEnumeration.CRUSHED_STANDING_ROOM_ONLY -> OccupancyStatus.CRUSHED_STANDING_ROOM_ONLY;
            case OccupancyEnumeration.FULL -> OccupancyStatus.FULL;
            case OccupancyEnumeration.NOT_ACCEPTING_PASSENGERS -> OccupancyStatus.NOT_ACCEPTING_PASSENGERS;
            case OccupancyEnumeration.UNDEFINED, OccupancyEnumeration.UNKNOWN -> OccupancyStatus.NO_DATA_AVAILABLE;
        };
    }
}

