/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.time.ZonedDateTime;
import java.util.function.Supplier;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import org.opentripplanner.updater.trip.siri.mapping.OccupancyMapper;
import org.opentripplanner.utils.time.ServiceDateUtils;
import uk.org.siri.siri21.NaturalLanguageStringStructure;
import uk.org.siri.siri21.OccupancyEnumeration;

class TimetableHelper {
    TimetableHelper() {
    }

    @SafeVarargs
    private static int getAvailableTime(ZonedDateTime startOfService, Supplier<ZonedDateTime> ... timeSuppliers) {
        for (Supplier<ZonedDateTime> supplier : timeSuppliers) {
            ZonedDateTime time = supplier.get();
            if (time == null) continue;
            return ServiceDateUtils.secondsSinceStartOfService((ZonedDateTime)startOfService, (ZonedDateTime)time);
        }
        return -1;
    }

    private static int handleMissingRealtime(int ... times) {
        int t;
        if (times.length == 0) {
            throw new IllegalArgumentException("Need at least one value");
        }
        int time = -1;
        int[] nArray = times;
        int n = nArray.length;
        for (int i = 0; i < n && (time = (t = nArray[i])) < 0; ++i) {
        }
        return time;
    }

    public static void applyUpdates(ZonedDateTime departureDate, RealTimeTripTimesBuilder tripTimesBuilder, int index, boolean isLastStop, boolean isJourneyPredictionInaccurate, CallWrapper call, OccupancyEnumeration journeyOccupancy) {
        OccupancyEnumeration callOccupancy;
        int[] nArray;
        int[] nArray2;
        if (call.getActualDepartureTime() != null || call.getActualArrivalTime() != null) {
            tripTimesBuilder.withRecorded(index);
        }
        boolean isCallPredictionInaccurate = Boolean.TRUE.equals(call.isPredictionInaccurate());
        if (isJourneyPredictionInaccurate || isCallPredictionInaccurate) {
            tripTimesBuilder.withInaccuratePredictions(index);
        }
        if (Boolean.TRUE.equals(call.isCancellation())) {
            tripTimesBuilder.withCanceled(index);
        }
        int scheduledArrivalTime = tripTimesBuilder.getArrivalTime(index);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = call::getActualArrivalTime;
        supplierArray[1] = call::getExpectedArrivalTime;
        int realTimeArrivalTime = TimetableHelper.getAvailableTime(departureDate, supplierArray);
        int scheduledDepartureTime = tripTimesBuilder.getDepartureTime(index);
        Supplier[] supplierArray2 = new Supplier[2];
        supplierArray2[0] = call::getActualDepartureTime;
        supplierArray2[1] = call::getExpectedDepartureTime;
        int realTimeDepartureTime = TimetableHelper.getAvailableTime(departureDate, supplierArray2);
        if (index == 0) {
            int[] nArray3 = new int[3];
            nArray3[0] = realTimeArrivalTime;
            nArray3[1] = realTimeDepartureTime;
            nArray2 = nArray3;
            nArray3[2] = scheduledArrivalTime;
        } else {
            int[] nArray4 = new int[2];
            nArray4[0] = realTimeArrivalTime;
            nArray2 = nArray4;
            nArray4[1] = scheduledArrivalTime;
        }
        int[] possibleArrivalTimes = nArray2;
        int arrivalTime = TimetableHelper.handleMissingRealtime(possibleArrivalTimes);
        int arrivalDelay = arrivalTime - scheduledArrivalTime;
        tripTimesBuilder.withArrivalDelay(index, arrivalDelay);
        if (isLastStop) {
            int[] nArray5 = new int[3];
            nArray5[0] = realTimeDepartureTime;
            nArray5[1] = realTimeArrivalTime;
            nArray = nArray5;
            nArray5[2] = scheduledDepartureTime;
        } else {
            int[] nArray6 = new int[2];
            nArray6[0] = realTimeDepartureTime;
            nArray = nArray6;
            nArray6[1] = scheduledDepartureTime;
        }
        int[] possibleDepartureTimes = nArray;
        int departureTime = TimetableHelper.handleMissingRealtime(possibleDepartureTimes);
        int departureDelay = departureTime - scheduledDepartureTime;
        tripTimesBuilder.withDepartureDelay(index, departureDelay);
        OccupancyEnumeration occupancyEnumeration = callOccupancy = call.getOccupancy() != null ? call.getOccupancy() : journeyOccupancy;
        if (callOccupancy != null) {
            tripTimesBuilder.withOccupancyStatus(index, OccupancyMapper.mapOccupancyStatus(callOccupancy));
        }
        if (call.getDestinationDisplaies() != null && !call.getDestinationDisplaies().isEmpty()) {
            NaturalLanguageStringStructure destinationDisplay = call.getDestinationDisplaies().get(0);
            tripTimesBuilder.withStopHeadsign(index, new NonLocalizedString(destinationDisplay.getValue()));
        }
    }
}

