/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import org.opentripplanner.updater.trip.siri.EntityResolver;
import org.opentripplanner.updater.trip.siri.mapping.PickDropMapper;
import org.opentripplanner.updater.trip.siri.support.NaturalLanguageStringHelper;
import org.opentripplanner.utils.time.ServiceDateUtils;

class StopTimesMapper {
    private final EntityResolver entityResolver;
    private final ZoneId zoneId;

    public StopTimesMapper(EntityResolver entityResolver, ZoneId zoneId) {
        this.entityResolver = entityResolver;
        this.zoneId = zoneId;
    }

    @Nullable
    StopTime createAimedStopTime(Trip trip, ZonedDateTime departureDate, int stopSequence, CallWrapper call, boolean isFirstStop, boolean isLastStop) {
        RegularStop stop = this.entityResolver.resolveQuay(call.getStopPointRef());
        if (stop == null) {
            return null;
        }
        StopTime stopTime = new StopTime();
        stopTime.setStopSequence(stopSequence);
        stopTime.setTrip(trip);
        stopTime.setStop(stop);
        ZonedDateTime aimedArrivalTime = call.getAimedArrivalTime() != null ? call.getAimedArrivalTime() : call.getAimedDepartureTime();
        int aimedArrivalTimeSeconds = ServiceDateUtils.secondsSinceStartOfService((ZonedDateTime)departureDate, (ZonedDateTime)aimedArrivalTime, (ZoneId)this.zoneId);
        ZonedDateTime aimedDepartureTime = call.getAimedDepartureTime() != null ? call.getAimedDepartureTime() : call.getAimedArrivalTime();
        int aimedDepartureTimeSeconds = ServiceDateUtils.secondsSinceStartOfService((ZonedDateTime)departureDate, (ZonedDateTime)aimedDepartureTime, (ZoneId)this.zoneId);
        stopTime.setArrivalTime(isFirstStop ? aimedDepartureTimeSeconds : aimedArrivalTimeSeconds);
        stopTime.setDepartureTime(isLastStop ? aimedArrivalTimeSeconds : aimedDepartureTimeSeconds);
        String destinationDisplay = NaturalLanguageStringHelper.getFirstStringFromList(call.getDestinationDisplaies());
        if (!destinationDisplay.isEmpty()) {
            stopTime.setStopHeadsign(new NonLocalizedString(destinationDisplay));
        } else if (trip.getHeadsign() != null) {
            stopTime.setStopHeadsign(trip.getHeadsign());
        } else {
            stopTime.setStopHeadsign(new NonLocalizedString(""));
        }
        PickDropMapper.mapPickUpType(call, stopTime.getPickupType()).ifPresent(stopTime::setPickupType);
        PickDropMapper.mapDropOffType(call, stopTime.getDropOffType()).ifPresent(stopTime::setDropOffType);
        return stopTime;
    }
}

