/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.util.concurrent.atomic.AtomicInteger;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.Trip;

class SiriTripPatternIdGenerator {
    private final AtomicInteger counter = new AtomicInteger(0);

    SiriTripPatternIdGenerator() {
    }

    FeedScopedId generateUniqueTripPatternId(Trip trip) {
        Route route = trip.getRoute();
        FeedScopedId routeId = route.getId();
        Direction direction = trip.getDirection();
        String directionId = direction == Direction.UNKNOWN ? "" : Integer.toString(direction.gtfsCode);
        String id = String.format("%s:%s:%03d:RT", routeId.getId(), directionId, this.counter.incrementAndGet());
        return new FeedScopedId(routeId.getFeedId(), id);
    }
}

