/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.updater.trip.siri.SiriTripPatternIdGenerator;

class SiriTripPatternCache {
    private final Map<StopPattern, TripPattern> cache = new HashMap<StopPattern, TripPattern>();
    private final SiriTripPatternIdGenerator tripPatternIdGenerator;
    private final Function<Trip, TripPattern> getPatternForTrip;

    public SiriTripPatternCache(SiriTripPatternIdGenerator tripPatternIdGenerator, Function<Trip, TripPattern> getPatternForTrip) {
        this.tripPatternIdGenerator = tripPatternIdGenerator;
        this.getPatternForTrip = getPatternForTrip;
    }

    public synchronized TripPattern getOrCreateTripPattern(StopPattern stopPattern, Trip trip) {
        TripPattern originalTripPattern = this.getPatternForTrip.apply(trip);
        if (originalTripPattern.getStopPattern().equals(stopPattern)) {
            return originalTripPattern;
        }
        TripPattern tripPattern = this.cache.get(stopPattern);
        if (tripPattern == null) {
            FeedScopedId id = this.tripPatternIdGenerator.generateUniqueTripPatternId(trip);
            tripPattern = (TripPattern)TripPattern.of(id).withRoute(trip.getRoute()).withMode(trip.getMode()).withNetexSubmode(trip.getNetexSubMode()).withStopPattern(stopPattern).withCreatedByRealtimeUpdater(true).withOriginalTripPattern(originalTripPattern).build();
            this.cache.put(stopPattern, tripPattern);
        }
        return tripPattern;
    }
}

