/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.model.RealTimeTripUpdate;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.transit.service.TransitEditorService;
import org.opentripplanner.updater.spi.DataValidationExceptionMapper;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.spi.UpdateSuccess;
import org.opentripplanner.updater.trip.TimetableSnapshotManager;
import org.opentripplanner.updater.trip.UpdateIncrementality;
import org.opentripplanner.updater.trip.siri.AddedTripBuilder;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import org.opentripplanner.updater.trip.siri.DebugString;
import org.opentripplanner.updater.trip.siri.EntityResolver;
import org.opentripplanner.updater.trip.siri.ExtraCallTripBuilder;
import org.opentripplanner.updater.trip.siri.ModifiedTripBuilder;
import org.opentripplanner.updater.trip.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.updater.trip.siri.SiriTripPatternCache;
import org.opentripplanner.updater.trip.siri.SiriTripPatternIdGenerator;
import org.opentripplanner.updater.trip.siri.TripAndPattern;
import org.opentripplanner.updater.trip.siri.TripUpdate;
import org.opentripplanner.utils.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.EstimatedTimetableDeliveryStructure;
import uk.org.siri.siri21.EstimatedVehicleJourney;
import uk.org.siri.siri21.EstimatedVersionFrameStructure;

public class SiriRealTimeTripUpdateAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SiriRealTimeTripUpdateAdapter.class);
    private final SiriTripPatternIdGenerator tripPatternIdGenerator = new SiriTripPatternIdGenerator();
    private final SiriTripPatternCache tripPatternCache;
    private final TransitEditorService transitEditorService;
    private final TimetableSnapshotManager snapshotManager;

    public SiriRealTimeTripUpdateAdapter(TimetableRepository timetableRepository, TimetableSnapshotManager snapshotManager) {
        this.snapshotManager = snapshotManager;
        this.transitEditorService = new DefaultTransitService(timetableRepository, snapshotManager.getTimetableSnapshotBuffer());
        this.tripPatternCache = new SiriTripPatternCache(this.tripPatternIdGenerator, this.transitEditorService::findPattern);
    }

    public UpdateResult applyEstimatedTimetable(@Nullable SiriFuzzyTripMatcher fuzzyTripMatcher, EntityResolver entityResolver, String feedId, UpdateIncrementality incrementality, List<EstimatedTimetableDeliveryStructure> updates) {
        if (updates == null) {
            LOG.warn("updates is null");
            return UpdateResult.empty();
        }
        ArrayList<Result<UpdateSuccess, UpdateError>> results = new ArrayList<Result<UpdateSuccess, UpdateError>>();
        if (incrementality == UpdateIncrementality.FULL_DATASET) {
            this.snapshotManager.clearBuffer(feedId);
        }
        for (EstimatedTimetableDeliveryStructure etDelivery : updates) {
            for (EstimatedVersionFrameStructure estimatedJourneyVersion : etDelivery.getEstimatedJourneyVersionFrames()) {
                List journeys = estimatedJourneyVersion.getEstimatedVehicleJourneies();
                LOG.debug("Handling {} EstimatedVehicleJourneys.", (Object)journeys.size());
                for (EstimatedVehicleJourney journey : journeys) {
                    results.add(this.apply(journey, this.transitEditorService, fuzzyTripMatcher, entityResolver));
                }
            }
        }
        LOG.debug("message contains {} trip updates", (Object)updates.size());
        return UpdateResult.ofResults(results);
    }

    private Result<UpdateSuccess, UpdateError> apply(EstimatedVehicleJourney journey, TransitEditorService transitService, @Nullable SiriFuzzyTripMatcher fuzzyTripMatcher, EntityResolver entityResolver) {
        List<CallWrapper> callWrappers = CallWrapper.of(journey);
        for (CallWrapper call : callWrappers) {
            if (!StringUtils.hasNoValueOrNullAsString((String)call.getStopPointRef())) continue;
            return UpdateError.result(null, UpdateError.UpdateErrorType.EMPTY_STOP_POINT_REF, journey.getDataSource());
        }
        SiriUpdateType siriUpdateType = null;
        try {
            Result<TripUpdate, UpdateError> result;
            siriUpdateType = this.updateType(journey, callWrappers, entityResolver);
            switch (siriUpdateType.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 1: {
                    Result<TripUpdate, UpdateError> result2 = new AddedTripBuilder(journey, transitService, entityResolver, this.tripPatternIdGenerator::generateUniqueTripPatternId).build();
                    break;
                }
                case 2: {
                    Result<TripUpdate, UpdateError> result2 = this.handleExtraCall(fuzzyTripMatcher, entityResolver, journey);
                    break;
                }
                case 0: {
                    Result<TripUpdate, UpdateError> result2 = result = this.handleModifiedTrip(fuzzyTripMatcher, entityResolver, journey);
                }
            }
            if (result.isFailure()) {
                return result.toFailureResult();
            }
            return this.addTripToGraphAndBuffer(result.successValue());
        }
        catch (DataValidationException e) {
            return DataValidationExceptionMapper.toResult(e, journey.getDataSource());
        }
        catch (Exception e) {
            LOG.warn("{} EstimatedJourney {} failed.", new Object[]{siriUpdateType, DebugString.of(journey), e});
            return Result.failure(UpdateError.noTripId(UpdateError.UpdateErrorType.UNKNOWN));
        }
    }

    private SiriUpdateType updateType(EstimatedVehicleJourney vehicleJourney, List<CallWrapper> callWrappers, EntityResolver entityResolver) {
        if (callWrappers.stream().anyMatch(CallWrapper::isExtraCall)) {
            return SiriUpdateType.EXTRA_CALL;
        }
        if (Boolean.TRUE.equals(vehicleJourney.isExtraJourney()) && entityResolver.resolveTrip(vehicleJourney) == null) {
            return SiriUpdateType.REPLACEMENT_DEPARTURE;
        }
        return SiriUpdateType.TRIP_UPDATE;
    }

    private Timetable getCurrentTimetable(TripPattern tripPattern, LocalDate serviceDate) {
        return this.snapshotManager.getTimetableSnapshotBuffer().resolve(tripPattern, serviceDate);
    }

    private Result<TripUpdate, UpdateError> handleModifiedTrip(@Nullable SiriFuzzyTripMatcher fuzzyTripMatcher, EntityResolver entityResolver, EstimatedVehicleJourney estimatedVehicleJourney) {
        TripPattern pattern;
        Trip trip = entityResolver.resolveTrip(estimatedVehicleJourney);
        String dataSource = estimatedVehicleJourney.getDataSource();
        if (!Boolean.TRUE.equals(estimatedVehicleJourney.isMonitored()) && !Boolean.TRUE.equals(estimatedVehicleJourney.isCancellation())) {
            return UpdateError.result(trip != null ? trip.getId() : null, UpdateError.UpdateErrorType.NOT_MONITORED, dataSource);
        }
        LocalDate serviceDate = entityResolver.resolveServiceDate(estimatedVehicleJourney);
        if (serviceDate == null) {
            return UpdateError.result(trip != null ? trip.getId() : null, UpdateError.UpdateErrorType.NO_START_DATE, dataSource);
        }
        if (trip != null) {
            pattern = this.transitEditorService.findPattern(trip);
        } else if (fuzzyTripMatcher != null) {
            Result<TripAndPattern, UpdateError.UpdateErrorType> result = fuzzyTripMatcher.match(estimatedVehicleJourney, entityResolver, this::getCurrentTimetable, this.snapshotManager::getNewTripPatternForModifiedTrip);
            if (result.isFailure()) {
                LOG.debug("No trips found for EstimatedVehicleJourney. {}", (Object)DebugString.of(estimatedVehicleJourney));
                return UpdateError.result(null, result.failureValue(), dataSource);
            }
            TripAndPattern tripAndPattern = result.successValue();
            trip = tripAndPattern.trip();
            pattern = tripAndPattern.tripPattern();
        } else {
            return UpdateError.result(null, UpdateError.UpdateErrorType.TRIP_NOT_FOUND, dataSource);
        }
        Timetable currentTimetable = this.getCurrentTimetable(pattern, serviceDate);
        TripTimes existingTripTimes = currentTimetable.getTripTimes(trip);
        if (existingTripTimes == null) {
            LOG.debug("tripId {} not found in pattern.", (Object)trip.getId());
            return UpdateError.result(trip.getId(), UpdateError.UpdateErrorType.TRIP_NOT_FOUND_IN_PATTERN, dataSource);
        }
        Result<TripUpdate, UpdateError> updateResult = new ModifiedTripBuilder(existingTripTimes, pattern, estimatedVehicleJourney, serviceDate, this.transitEditorService.getTimeZone(), entityResolver).build();
        if (updateResult.isFailure()) {
            return updateResult.toFailureResult();
        }
        if (!updateResult.successValue().stopPattern().equals(pattern.getStopPattern())) {
            this.markScheduledTripAsDeleted(trip, serviceDate);
        }
        this.snapshotManager.revertTripToScheduledTripPattern(trip.getId(), serviceDate);
        return updateResult;
    }

    private Result<TripUpdate, UpdateError> handleExtraCall(@Nullable SiriFuzzyTripMatcher fuzzyTripMatcher, EntityResolver entityResolver, EstimatedVehicleJourney estimatedVehicleJourney) {
        TripPattern pattern;
        Trip trip = entityResolver.resolveTrip(estimatedVehicleJourney);
        String dataSource = estimatedVehicleJourney.getDataSource();
        if (!Boolean.TRUE.equals(estimatedVehicleJourney.isMonitored()) && !Boolean.TRUE.equals(estimatedVehicleJourney.isCancellation())) {
            return UpdateError.result(trip != null ? trip.getId() : null, UpdateError.UpdateErrorType.NOT_MONITORED, dataSource);
        }
        LocalDate serviceDate = entityResolver.resolveServiceDate(estimatedVehicleJourney);
        if (serviceDate == null) {
            return UpdateError.result(trip != null ? trip.getId() : null, UpdateError.UpdateErrorType.NO_START_DATE, dataSource);
        }
        if (trip != null) {
            pattern = this.transitEditorService.findPattern(trip);
        } else if (fuzzyTripMatcher != null) {
            Result<TripAndPattern, UpdateError.UpdateErrorType> result = fuzzyTripMatcher.match(estimatedVehicleJourney, entityResolver, this::getCurrentTimetable, this.snapshotManager::getNewTripPatternForModifiedTrip);
            if (result.isFailure()) {
                LOG.debug("No trips found for EstimatedVehicleJourney. {}", (Object)DebugString.of(estimatedVehicleJourney));
                return UpdateError.result(null, result.failureValue(), dataSource);
            }
            TripAndPattern tripAndPattern = result.successValue();
            trip = tripAndPattern.trip();
            pattern = tripAndPattern.tripPattern();
        } else {
            return UpdateError.result(null, UpdateError.UpdateErrorType.TRIP_NOT_FOUND, dataSource);
        }
        Timetable currentTimetable = this.getCurrentTimetable(pattern, serviceDate);
        TripTimes existingTripTimes = currentTimetable.getTripTimes(trip);
        if (existingTripTimes == null) {
            LOG.debug("tripId {} not found in pattern.", (Object)trip.getId());
            return UpdateError.result(trip.getId(), UpdateError.UpdateErrorType.TRIP_NOT_FOUND_IN_PATTERN, dataSource);
        }
        Result<TripUpdate, UpdateError> updateResult = new ExtraCallTripBuilder(estimatedVehicleJourney, this.transitEditorService, entityResolver, this.tripPatternIdGenerator::generateUniqueTripPatternId, trip).build();
        if (updateResult.isFailure()) {
            return updateResult.toFailureResult();
        }
        if (!updateResult.successValue().stopPattern().equals(pattern.getStopPattern())) {
            this.markScheduledTripAsDeleted(trip, serviceDate);
        }
        this.snapshotManager.revertTripToScheduledTripPattern(trip.getId(), serviceDate);
        return updateResult;
    }

    private Result<UpdateSuccess, UpdateError> addTripToGraphAndBuffer(TripUpdate tripUpdate) {
        Trip trip = tripUpdate.tripTimes().getTrip();
        LocalDate serviceDate = tripUpdate.serviceDate();
        TripPattern pattern = tripUpdate.tripPatternCreation() ? tripUpdate.addedTripPattern() : this.tripPatternCache.getOrCreateTripPattern(tripUpdate.stopPattern(), trip);
        RealTimeTripUpdate realTimeTripUpdate = new RealTimeTripUpdate(pattern, tripUpdate.tripTimes(), serviceDate, tripUpdate.addedTripOnServiceDate(), tripUpdate.tripCreation(), tripUpdate.routeCreation(), tripUpdate.dataSource());
        Result<UpdateSuccess, UpdateError> result = this.snapshotManager.updateBuffer(realTimeTripUpdate);
        LOG.debug("Applied real-time data for trip {} on {}", (Object)trip, (Object)serviceDate);
        return result;
    }

    private boolean markScheduledTripAsDeleted(Trip trip, LocalDate serviceDate) {
        boolean success = false;
        TripPattern pattern = this.transitEditorService.findPattern(trip);
        if (pattern != null) {
            Timetable timetable = pattern.getScheduledTimetable();
            TripTimes tripTimes = timetable.getTripTimes(trip);
            if (tripTimes == null) {
                LOG.warn("Could not mark scheduled trip as deleted {}", (Object)trip.getId());
            } else {
                RealTimeTripTimesBuilder builder = tripTimes.createRealTimeFromScheduledTimes();
                builder.deleteTrip();
                this.snapshotManager.updateBuffer(new RealTimeTripUpdate(pattern, builder.build(), serviceDate));
                success = true;
            }
        }
        return success;
    }

    private static enum SiriUpdateType {
        TRIP_UPDATE,
        REPLACEMENT_DEPARTURE,
        EXTRA_CALL;

    }
}

