/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import org.opentripplanner.updater.trip.siri.EntityResolver;
import org.opentripplanner.updater.trip.siri.TripAndPattern;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.EstimatedVehicleJourney;
import uk.org.siri.siri21.VehicleModesEnumeration;

public class SiriFuzzyTripMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SiriFuzzyTripMatcher.class);
    private final Map<String, Set<Trip>> internalPlanningCodeCache = new HashMap<String, Set<Trip>>();
    private final Map<String, Set<Trip>> startStopTripCache = new HashMap<String, Set<Trip>>();
    private final TransitService transitService;

    public SiriFuzzyTripMatcher(TransitService transitService) {
        this.transitService = transitService;
        this.initCache(this.transitService);
    }

    public Result<TripAndPattern, UpdateError.UpdateErrorType> match(EstimatedVehicleJourney journey, EntityResolver entityResolver, BiFunction<TripPattern, LocalDate, Timetable> getCurrentTimetable, BiFunction<FeedScopedId, LocalDate, TripPattern> getNewTripPatternForModifiedTrip) {
        String lineRef;
        Route route;
        List<CallWrapper> calls = CallWrapper.of(journey);
        if (calls.isEmpty()) {
            return Result.failure(UpdateError.UpdateErrorType.NO_VALID_STOPS);
        }
        if (calls.getFirst().getAimedDepartureTime() == null) {
            return Result.failure(UpdateError.UpdateErrorType.NO_FUZZY_TRIP_MATCH);
        }
        Set<Trip> trips = null;
        if (journey.getVehicleRef() != null && journey.getVehicleModes().contains(VehicleModesEnumeration.RAIL)) {
            trips = this.getCachedTripsByInternalPlanningCode(journey.getVehicleRef().getValue());
        }
        if (trips == null || trips.isEmpty()) {
            ZonedDateTime arrivalTime;
            CallWrapper lastCall = calls.getLast();
            RegularStop stop = entityResolver.resolveQuay(lastCall.getStopPointRef());
            if (stop == null) {
                return Result.failure(UpdateError.UpdateErrorType.NO_FUZZY_TRIP_MATCH);
            }
            ZonedDateTime zonedDateTime = arrivalTime = lastCall.getAimedArrivalTime() != null ? lastCall.getAimedArrivalTime() : lastCall.getAimedDepartureTime();
            if (arrivalTime != null) {
                trips = this.getMatchingTripsOnStopOrSiblings(stop, arrivalTime);
            }
        }
        if (trips == null || trips.isEmpty()) {
            return Result.failure(UpdateError.UpdateErrorType.NO_FUZZY_TRIP_MATCH);
        }
        if (journey.getLineRef() != null && (route = entityResolver.resolveRoute(lineRef = journey.getLineRef().getValue())) != null) {
            trips = trips.stream().filter(trip -> trip.getRoute().equals(route)).collect(Collectors.toSet());
        }
        return this.getTripAndPatternForJourney(trips, calls, entityResolver, getCurrentTimetable, getNewTripPatternForModifiedTrip);
    }

    public List<FeedScopedId> getTripIdForInternalPlanningCodeServiceDate(String internalPlanningCode, LocalDate serviceDate) {
        ArrayList<FeedScopedId> matches = new ArrayList<FeedScopedId>();
        for (Trip trip : this.getCachedTripsByInternalPlanningCode(internalPlanningCode)) {
            Set<LocalDate> serviceDates = this.transitService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
            if (!serviceDates.contains(serviceDate)) continue;
            matches.add(trip.getId());
        }
        return matches;
    }

    private void initCache(TransitService index) {
        for (Trip trip : index.listTrips()) {
            String internalPlanningCode;
            TripPattern tripPattern = index.findPattern(trip);
            if (tripPattern == null) continue;
            if (tripPattern.getRoute().getMode().equals(TransitMode.RAIL) && (internalPlanningCode = trip.getNetexInternalPlanningCode()) != null) {
                this.internalPlanningCodeCache.computeIfAbsent(internalPlanningCode, key -> new HashSet()).add(trip);
            }
            String lastStopId = tripPattern.lastStop().getId().getId();
            TripTimes tripTimes = tripPattern.getScheduledTimetable().getTripTimes(trip);
            if (tripTimes == null) continue;
            int arrivalTime = tripTimes.getArrivalTime(tripTimes.getNumStops() - 1);
            String key2 = SiriFuzzyTripMatcher.createStartStopKey(lastStopId, arrivalTime);
            this.startStopTripCache.computeIfAbsent(key2, k -> new HashSet()).add(trip);
        }
        LOG.info("Built internalPlanningCode-cache [{}].", (Object)this.internalPlanningCodeCache.size());
        LOG.info("Built start-stop-cache [{}].", (Object)this.startStopTripCache.size());
    }

    private static String createStartStopKey(RegularStop stop, int lastStopArrivalTime) {
        return SiriFuzzyTripMatcher.createStartStopKey(stop.getId().getId(), lastStopArrivalTime);
    }

    private static String createStartStopKey(String lastStopId, int lastStopArrivalTime) {
        return lastStopId + ":" + lastStopArrivalTime;
    }

    private Set<Trip> getMatchingTripsOnStopOrSiblings(RegularStop lastStop, ZonedDateTime arrivalTime) {
        int secondsSinceMidnight = ServiceDateUtils.secondsSinceStartOfService((ZonedDateTime)arrivalTime, (ZonedDateTime)arrivalTime, (ZoneId)this.transitService.getTimeZone());
        int secondsSinceMidnightYesterday = ServiceDateUtils.secondsSinceStartOfService((ZonedDateTime)arrivalTime.minusDays(1L), (ZonedDateTime)arrivalTime, (ZoneId)this.transitService.getTimeZone());
        Set<Trip> trips = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(lastStop, secondsSinceMidnight));
        if (trips == null) {
            trips = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(lastStop, secondsSinceMidnightYesterday));
        }
        if (trips != null) {
            return trips;
        }
        if (!lastStop.isPartOfStation()) {
            return Set.of();
        }
        trips = new HashSet<Trip>();
        Collection<StopLocation> allQuays = lastStop.getParentStation().getChildStops();
        for (StopLocation quay : allQuays) {
            Set<Trip> tripSet = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(quay.getId().getId(), secondsSinceMidnight));
            if (tripSet == null) continue;
            trips.addAll(tripSet);
        }
        return trips;
    }

    private Set<Trip> getCachedTripsByInternalPlanningCode(String internalPlanningCode) {
        if (internalPlanningCode == null) {
            return null;
        }
        return this.internalPlanningCodeCache.getOrDefault(internalPlanningCode, new HashSet());
    }

    private Result<TripAndPattern, UpdateError.UpdateErrorType> getTripAndPatternForJourney(Set<Trip> trips, List<CallWrapper> calls, EntityResolver entityResolver, BiFunction<TripPattern, LocalDate, Timetable> getCurrentTimetable, BiFunction<FeedScopedId, LocalDate, TripPattern> getNewTripPatternForModifiedTrip) {
        RegularStop journeyFirstStop = entityResolver.resolveQuay(calls.getFirst().getStopPointRef());
        RegularStop journeyLastStop = entityResolver.resolveQuay(calls.getLast().getStopPointRef());
        if (journeyFirstStop == null || journeyLastStop == null) {
            return Result.failure(UpdateError.UpdateErrorType.NO_VALID_STOPS);
        }
        ZonedDateTime date = calls.getFirst().getAimedDepartureTime();
        LocalDate serviceDate = date.toLocalDate();
        int departureInSecondsSinceMidnight = ServiceDateUtils.secondsSinceStartOfService((ZonedDateTime)date, (ZonedDateTime)date, (ZoneId)this.transitService.getTimeZone());
        CalendarService calendarService = this.transitService.getCalendarService();
        HashSet<TripAndPattern> possibleTrips = new HashSet<TripAndPattern>();
        for (Trip trip : trips) {
            TripTimes times;
            boolean lastStopIsMatch;
            if (!calendarService.getServiceDatesForServiceId(trip.getServiceId()).contains(serviceDate)) continue;
            TripPattern newTripPatternForModifiedTrip = getNewTripPatternForModifiedTrip.apply(trip.getId(), serviceDate);
            TripPattern tripPattern = newTripPatternForModifiedTrip != null ? newTripPatternForModifiedTrip : this.transitService.findPattern(trip);
            StopLocation firstStop = tripPattern.firstStop();
            StopLocation lastStop = tripPattern.lastStop();
            boolean firstStopIsMatch = firstStop.equals(journeyFirstStop) || firstStop.isPartOfSameStationAs(journeyFirstStop);
            boolean bl = lastStopIsMatch = lastStop.equals(journeyLastStop) || lastStop.isPartOfSameStationAs(journeyLastStop);
            if (!firstStopIsMatch || !lastStopIsMatch || (times = getCurrentTimetable.apply(tripPattern, serviceDate).getTripTimes(trip)) == null || times.getScheduledDepartureTime(0) != departureInSecondsSinceMidnight) continue;
            possibleTrips.add(new TripAndPattern(times.getTrip(), tripPattern));
        }
        if (possibleTrips.isEmpty()) {
            return Result.failure(UpdateError.UpdateErrorType.NO_FUZZY_TRIP_MATCH);
        }
        if (possibleTrips.size() > 1) {
            LOG.warn("Multiple trip and pattern combinations found, skipping all, {}", possibleTrips);
            return Result.failure(UpdateError.UpdateErrorType.MULTIPLE_FUZZY_TRIP_MATCHES);
        }
        return Result.success((TripAndPattern)possibleTrips.iterator().next());
    }
}

