/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimes;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.updater.spi.DataValidationExceptionMapper;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import org.opentripplanner.updater.trip.siri.EntityResolver;
import org.opentripplanner.updater.trip.siri.TimetableHelper;
import org.opentripplanner.updater.trip.siri.TripUpdate;
import org.opentripplanner.updater.trip.siri.mapping.PickDropMapper;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.EstimatedVehicleJourney;
import uk.org.siri.siri21.OccupancyEnumeration;

class ModifiedTripBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ModifiedTripBuilder.class);
    private final TripTimes existingTripTimes;
    private final TripPattern pattern;
    private final LocalDate serviceDate;
    private final ZoneId zoneId;
    private final EntityResolver entityResolver;
    private final List<CallWrapper> calls;
    private final boolean cancellation;
    private final OccupancyEnumeration occupancy;
    private final boolean predictionInaccurate;
    private final String dataSource;

    public ModifiedTripBuilder(TripTimes existingTripTimes, TripPattern pattern, EstimatedVehicleJourney journey, LocalDate serviceDate, ZoneId zoneId, EntityResolver entityResolver) {
        this.existingTripTimes = existingTripTimes;
        this.pattern = pattern;
        this.serviceDate = serviceDate;
        this.zoneId = zoneId;
        this.entityResolver = entityResolver;
        this.calls = CallWrapper.of(journey);
        this.cancellation = Boolean.TRUE.equals(journey.isCancellation());
        this.predictionInaccurate = Boolean.TRUE.equals(journey.isPredictionInaccurate());
        this.occupancy = journey.getOccupancy();
        this.dataSource = journey.getDataSource();
    }

    public ModifiedTripBuilder(TripTimes existingTripTimes, TripPattern pattern, LocalDate serviceDate, ZoneId zoneId, EntityResolver entityResolver, List<CallWrapper> calls, boolean cancellation, OccupancyEnumeration occupancy, boolean predictionInaccurate, String dataSource) {
        this.existingTripTimes = existingTripTimes;
        this.pattern = pattern;
        this.serviceDate = serviceDate;
        this.zoneId = zoneId;
        this.entityResolver = entityResolver;
        this.calls = calls;
        this.cancellation = cancellation;
        this.occupancy = occupancy;
        this.predictionInaccurate = predictionInaccurate;
        this.dataSource = dataSource;
    }

    public Result<TripUpdate, UpdateError> build() {
        RealTimeTripTimesBuilder builder = this.existingTripTimes.createRealTimeFromScheduledTimes();
        if (this.cancellation) {
            return this.cancelTrip(builder);
        }
        if (this.calls.size() < this.existingTripTimes.getNumStops()) {
            return UpdateError.result(this.existingTripTimes.getTrip().getId(), UpdateError.UpdateErrorType.TOO_FEW_STOPS, this.dataSource);
        }
        if (this.calls.size() > this.existingTripTimes.getNumStops()) {
            return UpdateError.result(this.existingTripTimes.getTrip().getId(), UpdateError.UpdateErrorType.TOO_MANY_STOPS, this.dataSource);
        }
        Result<StopPattern, UpdateError> result = ModifiedTripBuilder.createStopPattern(this.pattern, this.calls, this.entityResolver);
        if (result.isFailure()) {
            int invalidStopIndex = result.failureValue().stopIndex();
            LOG.info("Invalid SIRI-ET data for trip {} - {} at stop index {}", new Object[]{this.existingTripTimes.getTrip().getId(), result.failureValue().errorType(), invalidStopIndex});
            return Result.failure(new UpdateError(this.existingTripTimes.getTrip().getId(), result.failureValue().errorType(), invalidStopIndex, this.dataSource));
        }
        StopPattern stopPattern = result.successValue();
        if (stopPattern.isAllStopsNonRoutable()) {
            return this.cancelTrip(builder);
        }
        this.applyUpdates(builder);
        if (this.pattern.getStopPattern().equals(stopPattern)) {
            builder.withRealTimeState(RealTimeState.UPDATED);
        } else {
            builder.withRealTimeState(RealTimeState.MODIFIED);
        }
        int numStopsInUpdate = builder.numberOfStops();
        int numStopsInPattern = this.pattern.numberOfStops();
        if (numStopsInUpdate != numStopsInPattern) {
            LOG.info("Invalid SIRI-ET data for trip {} - Inconsistent number of updated stops ({}) and stops in pattern ({})", new Object[]{builder.getTrip().getId(), numStopsInUpdate, numStopsInPattern});
            return UpdateError.result(this.existingTripTimes.getTrip().getId(), UpdateError.UpdateErrorType.TOO_FEW_STOPS, this.dataSource);
        }
        try {
            RealTimeTripTimes newTimes = builder.build();
            LOG.debug("A valid TripUpdate object was applied using the Timetable class update method.");
            return Result.success(new TripUpdate(stopPattern, newTimes, this.serviceDate, this.dataSource));
        }
        catch (DataValidationException e) {
            LOG.info("Invalid SIRI-ET data for trip {} - TripTimes failed to validate after applying SIRI delay propagation. {}", (Object)builder.getTrip().getId(), (Object)e.getMessage());
            return DataValidationExceptionMapper.toResult(e, this.dataSource);
        }
    }

    private Result<TripUpdate, UpdateError> cancelTrip(RealTimeTripTimesBuilder builder) {
        builder.cancelTrip();
        return Result.success(new TripUpdate(this.pattern.getStopPattern(), builder.build(), this.serviceDate, this.dataSource));
    }

    private void applyUpdates(RealTimeTripTimesBuilder builder) {
        ZonedDateTime startOfService = ServiceDateUtils.asStartOfService((LocalDate)this.serviceDate, (ZoneId)this.zoneId);
        HashSet<CallWrapper> alreadyVisited = new HashSet<CallWrapper>();
        List<StopLocation> stopsInPattern = this.pattern.getStops();
        for (int stopIndex = 0; stopIndex < stopsInPattern.size(); ++stopIndex) {
            StopLocation stopInPattern = stopsInPattern.get(stopIndex);
            CallWrapper matchingCall = null;
            for (CallWrapper call : this.calls) {
                RegularStop stopPoint;
                if (alreadyVisited.contains(call) || !stopInPattern.equals(stopPoint = this.entityResolver.resolveQuay(call.getStopPointRef())) && !stopInPattern.isPartOfSameStationAs(stopPoint)) continue;
                matchingCall = call;
                break;
            }
            if (matchingCall == null) {
                throw new IllegalStateException("The stop at index %d on the trip %s cannot be matched with any call. This implies a bug.".formatted(stopIndex, builder.getTrip().getId()));
            }
            TimetableHelper.applyUpdates(startOfService, builder, stopIndex, stopIndex == stopsInPattern.size() - 1, this.predictionInaccurate, matchingCall, this.occupancy);
            alreadyVisited.add(matchingCall);
        }
    }

    static Result<StopPattern, UpdateError> createStopPattern(TripPattern pattern, List<CallWrapper> calls, EntityResolver entityResolver) {
        int numberOfStops = pattern.numberOfStops();
        StopPattern.StopPatternBuilder builder = pattern.copyPlannedStopPattern();
        HashSet<CallWrapper> alreadyVisited = new HashSet<CallWrapper>();
        for (int i = 0; i < numberOfStops; ++i) {
            StopLocation stop = (StopLocation)builder.stops.original(i);
            boolean matchFound = false;
            for (CallWrapper call : calls) {
                if (alreadyVisited.contains(call)) continue;
                RegularStop callStop = entityResolver.resolveQuay(call.getStopPointRef());
                if (callStop == null) {
                    return Result.failure(new UpdateError(null, UpdateError.UpdateErrorType.UNKNOWN_STOP, i));
                }
                if (!stop.equals(callStop) && !stop.isPartOfSameStationAs(callStop)) continue;
                matchFound = true;
                int stopIndex = i;
                builder.stops.with(stopIndex, (Object)callStop);
                PickDropMapper.mapPickUpType(call, (PickDrop)((Object)builder.pickups.original(stopIndex))).ifPresent(value -> builder.pickups.with(stopIndex, (Object)value));
                PickDropMapper.mapDropOffType(call, (PickDrop)((Object)builder.dropoffs.original(stopIndex))).ifPresent(value -> builder.dropoffs.with(stopIndex, (Object)value));
                alreadyVisited.add(call);
                break;
            }
            if (matchFound) continue;
            return Result.failure(new UpdateError(null, UpdateError.UpdateErrorType.STOP_MISMATCH, i));
        }
        StopPattern newStopPattern = builder.build();
        return pattern.isModified() && pattern.getStopPattern().equals(newStopPattern) ? Result.success(pattern.getStopPattern()) : Result.success(newStopPattern);
    }
}

