/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimes;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimesFactory;
import org.opentripplanner.transit.service.TransitEditorService;
import org.opentripplanner.updater.spi.DataValidationExceptionMapper;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import org.opentripplanner.updater.trip.siri.EntityResolver;
import org.opentripplanner.updater.trip.siri.StopTimesMapper;
import org.opentripplanner.updater.trip.siri.TimetableHelper;
import org.opentripplanner.updater.trip.siri.TripUpdate;
import uk.org.siri.siri21.EstimatedVehicleJourney;
import uk.org.siri.siri21.OccupancyEnumeration;

class ExtraCallTripBuilder {
    private final TransitEditorService transitService;
    private final ZoneId timeZone;
    private final Function<Trip, FeedScopedId> generateTripPatternId;
    private final Trip trip;
    private final String dataSource;
    private final LocalDate serviceDate;
    private final List<CallWrapper> calls;
    private final boolean isJourneyPredictionInaccurate;
    private final OccupancyEnumeration occupancy;
    private final boolean cancellation;
    private final StopTimesMapper stopTimesMapper;

    ExtraCallTripBuilder(EstimatedVehicleJourney estimatedVehicleJourney, TransitEditorService transitService, EntityResolver entityResolver, Function<Trip, FeedScopedId> generateTripPatternId, Trip trip) {
        this.trip = Objects.requireNonNull(trip);
        this.dataSource = estimatedVehicleJourney.getDataSource();
        this.serviceDate = entityResolver.resolveServiceDate(estimatedVehicleJourney);
        this.isJourneyPredictionInaccurate = Boolean.TRUE.equals(estimatedVehicleJourney.isPredictionInaccurate());
        this.occupancy = estimatedVehicleJourney.getOccupancy();
        this.cancellation = Boolean.TRUE.equals(estimatedVehicleJourney.isCancellation());
        this.calls = CallWrapper.of(estimatedVehicleJourney);
        this.transitService = transitService;
        this.generateTripPatternId = generateTripPatternId;
        this.timeZone = transitService.getTimeZone();
        this.stopTimesMapper = new StopTimesMapper(entityResolver, this.timeZone);
    }

    Result<TripUpdate, UpdateError> build() {
        TripPattern originalPattern = this.transitService.findPattern(this.trip);
        long numExtraCalls = this.calls.stream().filter(CallWrapper::isExtraCall).count();
        if ((long)this.calls.size() - numExtraCalls != (long)originalPattern.numberOfStops()) {
            return UpdateError.result(this.trip.getId(), UpdateError.UpdateErrorType.INVALID_STOP_SEQUENCE, this.dataSource);
        }
        if (this.serviceDate == null) {
            return UpdateError.result(this.trip.getId(), UpdateError.UpdateErrorType.NO_START_DATE, this.dataSource);
        }
        FeedScopedId calServiceId = this.transitService.getOrCreateServiceIdForDate(this.serviceDate);
        if (calServiceId == null) {
            return UpdateError.result(this.trip.getId(), UpdateError.UpdateErrorType.NO_START_DATE, this.dataSource);
        }
        ZonedDateTime departureDate = this.serviceDate.atStartOfDay(this.timeZone);
        ArrayList<StopTime> aimedStopTimes = new ArrayList<StopTime>();
        int extraCallCounter = 0;
        for (int stopSequence = 0; stopSequence < this.calls.size(); ++stopSequence) {
            CallWrapper call = this.calls.get(stopSequence);
            StopTime stopTime = this.stopTimesMapper.createAimedStopTime(this.trip, departureDate, stopSequence, call, stopSequence == 0, stopSequence == this.calls.size() - 1);
            if (stopTime == null) {
                return UpdateError.result(this.trip.getId(), UpdateError.UpdateErrorType.UNKNOWN_STOP, this.dataSource);
            }
            if (call.isExtraCall()) {
                ++extraCallCounter;
            } else {
                StopLocation stopInOriginalPattern = originalPattern.getStop(stopSequence - extraCallCounter);
                StopLocation stopInNewPattern = stopTime.getStop();
                if (!stopInNewPattern.equals(stopInOriginalPattern) && !stopInNewPattern.isPartOfSameStationAs(stopInOriginalPattern)) {
                    return UpdateError.result(this.trip.getId(), UpdateError.UpdateErrorType.STOP_MISMATCH, this.dataSource);
                }
            }
            aimedStopTimes.add(stopTime);
        }
        StopPattern stopPattern = new StopPattern(aimedStopTimes);
        ScheduledTripTimes tripTimes = TripTimesFactory.tripTimes(this.trip, aimedStopTimes, this.transitService.getDeduplicator()).withServiceCode(this.transitService.getServiceCode(this.trip.getServiceId()));
        tripTimes.validateNonIncreasingTimes();
        TripPattern pattern = (TripPattern)TripPattern.of(this.generateTripPatternId.apply(this.trip)).withRoute(this.trip.getRoute()).withMode(this.trip.getMode()).withNetexSubmode(this.trip.getNetexSubMode()).withStopPattern(stopPattern).withScheduledTimeTableBuilder(builder -> builder.addTripTimes(tripTimes)).withCreatedByRealtimeUpdater(true).build();
        RealTimeTripTimesBuilder builder2 = tripTimes.createRealTimeFromScheduledTimes();
        for (int stopSequence = 0; stopSequence < this.calls.size(); ++stopSequence) {
            TimetableHelper.applyUpdates(departureDate, builder2, stopSequence, stopSequence == this.calls.size() - 1, this.isJourneyPredictionInaccurate, this.calls.get(stopSequence), this.occupancy);
        }
        if (this.cancellation || stopPattern.isAllStopsNonRoutable()) {
            builder2.cancelTrip();
        } else {
            builder2.withRealTimeState(RealTimeState.MODIFIED);
        }
        try {
            return Result.success(new TripUpdate(stopPattern, builder2.build(), this.serviceDate, null, pattern, false, this.dataSource));
        }
        catch (DataValidationException e) {
            return DataValidationExceptionMapper.toResult(e, this.dataSource);
        }
    }
}

