/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.DataFrameRefStructure;
import uk.org.siri.siri21.DatedVehicleJourneyRef;
import uk.org.siri.siri21.EstimatedVehicleJourney;
import uk.org.siri.siri21.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri21.MonitoredVehicleJourneyStructure;

public class EntityResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResolver.class);
    private final TransitService transitService;
    private final String feedId;

    public EntityResolver(TransitService transitService, String feedId) {
        this.transitService = transitService;
        this.feedId = feedId;
    }

    public FeedScopedId resolveId(String entityId) {
        return new FeedScopedId(this.feedId, entityId);
    }

    public Trip resolveTrip(EstimatedVehicleJourney journey) {
        Trip addedTrip;
        String datedServiceJourneyId;
        TripOnServiceDate tripOnServiceDate;
        Trip trip = this.resolveTrip(journey.getFramedVehicleJourneyRef());
        if (trip != null) {
            return trip;
        }
        if (journey.getDatedVehicleJourneyRef() != null && (tripOnServiceDate = this.transitService.getTripOnServiceDate(this.resolveId(datedServiceJourneyId = journey.getDatedVehicleJourneyRef().getValue()))) != null) {
            return tripOnServiceDate.getTrip();
        }
        if (journey.getEstimatedVehicleJourneyCode() != null && (addedTrip = this.transitService.getTrip(this.resolveId(journey.getEstimatedVehicleJourneyCode()))) != null) {
            return addedTrip;
        }
        return null;
    }

    public Trip resolveTrip(MonitoredVehicleJourneyStructure journey) {
        return this.resolveTrip(journey.getFramedVehicleJourneyRef());
    }

    public TripOnServiceDate resolveTripOnServiceDate(EstimatedVehicleJourney estimatedVehicleJourney) {
        FeedScopedId datedServiceJourneyId = this.resolveDatedServiceJourneyId(estimatedVehicleJourney);
        if (datedServiceJourneyId != null) {
            return this.resolveTripOnServiceDate(datedServiceJourneyId);
        }
        return this.resolveTripOnServiceDate(estimatedVehicleJourney.getFramedVehicleJourneyRef());
    }

    public TripOnServiceDate resolveTripOnServiceDate(String datedServiceJourneyId) {
        return this.resolveTripOnServiceDate(this.resolveId(datedServiceJourneyId));
    }

    public TripOnServiceDate resolveTripOnServiceDate(FramedVehicleJourneyRefStructure framedVehicleJourney) {
        return this.resolveTripOnServiceDate(framedVehicleJourney.getDatedVehicleJourneyRef(), this.resolveServiceDate(framedVehicleJourney));
    }

    @Nullable
    public TripOnServiceDate resolveTripOnServiceDate(String serviceJourneyId, @Nullable LocalDate serviceDate) {
        if (serviceDate == null) {
            return null;
        }
        return this.transitService.getTripOnServiceDate(new TripIdAndServiceDate(this.resolveId(serviceJourneyId), serviceDate));
    }

    public TripOnServiceDate resolveTripOnServiceDate(FeedScopedId datedServiceJourneyId) {
        return this.transitService.getTripOnServiceDate(datedServiceJourneyId);
    }

    public FeedScopedId resolveDatedServiceJourneyId(EstimatedVehicleJourney estimatedVehicleJourney) {
        DatedVehicleJourneyRef datedVehicleJourneyRef = estimatedVehicleJourney.getDatedVehicleJourneyRef();
        if (datedVehicleJourneyRef != null) {
            return this.resolveId(datedVehicleJourneyRef.getValue());
        }
        if (estimatedVehicleJourney.getEstimatedVehicleJourneyCode() != null) {
            return this.resolveId(estimatedVehicleJourney.getEstimatedVehicleJourneyCode());
        }
        return null;
    }

    public LocalDate resolveServiceDate(FramedVehicleJourneyRefStructure vehicleJourneyRefStructure) {
        DataFrameRefStructure dataFrame;
        if (vehicleJourneyRefStructure.getDataFrameRef() != null && (dataFrame = vehicleJourneyRefStructure.getDataFrameRef()) != null) {
            try {
                return LocalDate.parse(dataFrame.getValue());
            }
            catch (DateTimeParseException ignored) {
                LOG.warn("Invalid dataFrame format: {}", (Object)dataFrame.getValue());
            }
        }
        return null;
    }

    @Nullable
    public LocalDate resolveServiceDate(@Nullable ZonedDateTime originAimedDepartureTime) {
        if (originAimedDepartureTime == null) {
            return null;
        }
        return originAimedDepartureTime.toLocalDate();
    }

    @Nullable
    public Trip resolveTrip(@Nullable FramedVehicleJourneyRefStructure journey) {
        if (journey != null) {
            return this.resolveTrip(journey.getDatedVehicleJourneyRef());
        }
        return null;
    }

    public Trip resolveTrip(String serviceJourneyId) {
        return this.transitService.getTrip(this.resolveId(serviceJourneyId));
    }

    public RegularStop resolveQuay(String stopPointRef) {
        FeedScopedId id = this.resolveId(stopPointRef);
        return this.transitService.findStopByScheduledStopPoint(id).orElseGet(() -> this.transitService.getRegularStop(id));
    }

    public Route resolveRoute(String lineRef) {
        return this.transitService.getRoute(this.resolveId(lineRef));
    }

    public Operator resolveOperator(String operatorRef) {
        return this.transitService.getOperator(this.resolveId(operatorRef));
    }

    @Nullable
    public LocalDate resolveServiceDate(EstimatedVehicleJourney vehicleJourney) {
        TripOnServiceDate datedServiceJourney;
        FeedScopedId datedServiceJourneyId;
        DataFrameRefStructure dataFrame;
        if (vehicleJourney.getFramedVehicleJourneyRef() != null && (dataFrame = vehicleJourney.getFramedVehicleJourneyRef().getDataFrameRef()) != null) {
            try {
                return LocalDate.parse(dataFrame.getValue());
            }
            catch (DateTimeParseException ignored) {
                LOG.warn("Invalid dataFrame format: {}", (Object)dataFrame.getValue());
            }
        }
        if ((datedServiceJourneyId = this.resolveDatedServiceJourneyId(vehicleJourney)) != null && (datedServiceJourney = this.resolveTripOnServiceDate(datedServiceJourneyId)) != null) {
            return datedServiceJourney.getServiceDate();
        }
        Optional<ZonedDateTime> datetime = CallWrapper.of(vehicleJourney).stream().findFirst().map(CallWrapper::getAimedDepartureTime);
        if (datetime.isEmpty()) {
            return null;
        }
        int daysOffset = this.calculateDayOffset(vehicleJourney);
        return datetime.get().toLocalDate().minusDays(daysOffset);
    }

    private int calculateDayOffset(EstimatedVehicleJourney vehicleJourney) {
        Trip trip = this.resolveTrip(vehicleJourney);
        if (trip == null) {
            return 0;
        }
        TripPattern pattern = this.transitService.findPattern(trip);
        if (pattern == null) {
            return 0;
        }
        TripTimes tripTimes = pattern.getScheduledTimetable().getTripTimes(trip);
        if (tripTimes == null) {
            return 0;
        }
        int departureTime = tripTimes.getDepartureTime(0);
        int days = (int)Duration.ofSeconds(departureTime).toDays();
        if (departureTime < 0) {
            return days - 1;
        }
        return days;
    }
}

