/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.siri;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RouteBuilder;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimes;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripBuilder;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimesFactory;
import org.opentripplanner.transit.service.TransitEditorService;
import org.opentripplanner.updater.alert.siri.mapping.SiriTransportModeMapper;
import org.opentripplanner.updater.spi.DataValidationExceptionMapper;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.trip.siri.CallWrapper;
import org.opentripplanner.updater.trip.siri.EntityResolver;
import org.opentripplanner.updater.trip.siri.StopTimesMapper;
import org.opentripplanner.updater.trip.siri.TimetableHelper;
import org.opentripplanner.updater.trip.siri.TripUpdate;
import org.opentripplanner.updater.trip.siri.support.NaturalLanguageStringHelper;
import org.rutebanken.netex.model.BusSubmodeEnumeration;
import org.rutebanken.netex.model.RailSubmodeEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.EstimatedVehicleJourney;
import uk.org.siri.siri21.OccupancyEnumeration;
import uk.org.siri.siri21.VehicleJourneyRef;

class AddedTripBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AddedTripBuilder.class);
    private final TransitEditorService transitService;
    private final EntityResolver entityResolver;
    private final ZoneId timeZone;
    private final Function<Trip, FeedScopedId> getTripPatternId;
    private final FeedScopedId tripId;
    private final Operator operator;
    private final String dataSource;
    private final String lineRef;
    private final Route replacedRoute;
    private final LocalDate serviceDate;
    private final TransitMode transitMode;
    private final String transitSubMode;
    private final List<CallWrapper> calls;
    private final boolean isJourneyPredictionInaccurate;
    private final OccupancyEnumeration occupancy;
    private final boolean cancellation;
    private final String shortName;
    private final String headsign;
    private final List<TripOnServiceDate> replacedTrips;
    private final StopTimesMapper stopTimesMapper;

    AddedTripBuilder(EstimatedVehicleJourney estimatedVehicleJourney, TransitEditorService transitService, EntityResolver entityResolver, Function<Trip, FeedScopedId> getTripPatternId) {
        String newServiceJourneyRef = estimatedVehicleJourney.getEstimatedVehicleJourneyCode();
        Objects.requireNonNull(newServiceJourneyRef, "EstimatedVehicleJourneyCode is required");
        this.tripId = entityResolver.resolveId(newServiceJourneyRef);
        Objects.requireNonNull(estimatedVehicleJourney.getOperatorRef(), "OperatorRef is required");
        String operatorRef = estimatedVehicleJourney.getOperatorRef().getValue();
        this.operator = entityResolver.resolveOperator(operatorRef);
        this.dataSource = estimatedVehicleJourney.getDataSource();
        Objects.requireNonNull(estimatedVehicleJourney.getLineRef(), "LineRef is required");
        this.lineRef = estimatedVehicleJourney.getLineRef().getValue();
        String externalLineRef = estimatedVehicleJourney.getExternalLineRef() != null ? estimatedVehicleJourney.getExternalLineRef().getValue() : this.lineRef;
        this.replacedRoute = entityResolver.resolveRoute(externalLineRef);
        this.serviceDate = entityResolver.resolveServiceDate(estimatedVehicleJourney);
        this.shortName = NaturalLanguageStringHelper.getFirstStringFromList(estimatedVehicleJourney.getPublishedLineNames());
        List vehicleModes = estimatedVehicleJourney.getVehicleModes();
        this.transitMode = SiriTransportModeMapper.mapTransitMainMode(vehicleModes);
        this.transitSubMode = AddedTripBuilder.resolveTransitSubMode(this.transitMode, this.replacedRoute);
        this.isJourneyPredictionInaccurate = Boolean.TRUE.equals(estimatedVehicleJourney.isPredictionInaccurate());
        this.occupancy = estimatedVehicleJourney.getOccupancy();
        this.cancellation = Boolean.TRUE.equals(estimatedVehicleJourney.isCancellation());
        this.headsign = NaturalLanguageStringHelper.getFirstStringFromList(estimatedVehicleJourney.getDestinationNames());
        this.calls = CallWrapper.of(estimatedVehicleJourney);
        this.transitService = transitService;
        this.entityResolver = entityResolver;
        this.getTripPatternId = getTripPatternId;
        this.timeZone = transitService.getTimeZone();
        this.replacedTrips = this.getReplacedVehicleJourneys(estimatedVehicleJourney);
        this.stopTimesMapper = new StopTimesMapper(entityResolver, this.timeZone);
    }

    AddedTripBuilder(TransitEditorService transitService, EntityResolver entityResolver, Function<Trip, FeedScopedId> getTripPatternId, FeedScopedId tripId, Operator operator, String lineRef, Route replacedRoute, LocalDate serviceDate, TransitMode transitMode, String transitSubMode, List<CallWrapper> calls, boolean isJourneyPredictionInaccurate, OccupancyEnumeration occupancy, boolean cancellation, String shortName, String headsign, List<TripOnServiceDate> replacedTrips, String dataSource) {
        this.transitService = transitService;
        this.entityResolver = entityResolver;
        this.timeZone = transitService.getTimeZone();
        this.getTripPatternId = getTripPatternId;
        this.tripId = tripId;
        this.operator = operator;
        this.lineRef = lineRef;
        this.replacedRoute = replacedRoute;
        this.serviceDate = serviceDate;
        this.transitMode = transitMode;
        this.transitSubMode = transitSubMode;
        this.calls = calls;
        this.isJourneyPredictionInaccurate = isJourneyPredictionInaccurate;
        this.occupancy = occupancy;
        this.cancellation = cancellation;
        this.shortName = shortName;
        this.headsign = headsign;
        this.replacedTrips = replacedTrips;
        this.dataSource = dataSource;
        this.stopTimesMapper = new StopTimesMapper(entityResolver, this.timeZone);
    }

    Result<TripUpdate, UpdateError> build() {
        if (this.calls.size() < 2) {
            return UpdateError.result(this.tripId, UpdateError.UpdateErrorType.TOO_FEW_STOPS, this.dataSource);
        }
        if (this.serviceDate == null) {
            return UpdateError.result(this.tripId, UpdateError.UpdateErrorType.NO_START_DATE, this.dataSource);
        }
        FeedScopedId calServiceId = this.transitService.getOrCreateServiceIdForDate(this.serviceDate);
        if (calServiceId == null) {
            return UpdateError.result(this.tripId, UpdateError.UpdateErrorType.NO_START_DATE, this.dataSource);
        }
        boolean isAddedRoute = false;
        Route route = this.entityResolver.resolveRoute(this.lineRef);
        if (route == null) {
            Agency agency = this.resolveAgency();
            if (agency == null) {
                return UpdateError.result(this.tripId, UpdateError.UpdateErrorType.CANNOT_RESOLVE_AGENCY, this.dataSource);
            }
            route = this.createRoute(agency);
            isAddedRoute = true;
            LOG.info("Adding route {} to timetableRepository.", (Object)route);
        }
        Trip trip = this.createTrip(route, calServiceId);
        ZonedDateTime departureDate = this.serviceDate.atStartOfDay(this.timeZone);
        ArrayList<StopTime> aimedStopTimes = new ArrayList<StopTime>();
        for (int stopSequence = 0; stopSequence < this.calls.size(); ++stopSequence) {
            StopTime stopTime = this.stopTimesMapper.createAimedStopTime(trip, departureDate, stopSequence, this.calls.get(stopSequence), stopSequence == 0, stopSequence == this.calls.size() - 1);
            if (stopTime == null) {
                return UpdateError.result(this.tripId, UpdateError.UpdateErrorType.UNKNOWN_STOP, this.dataSource);
            }
            aimedStopTimes.add(stopTime);
        }
        StopPattern stopPattern = new StopPattern(aimedStopTimes);
        ScheduledTripTimes tripTimes = TripTimesFactory.tripTimes(trip, aimedStopTimes, this.transitService.getDeduplicator()).withServiceCode(this.transitService.getServiceCode(trip.getServiceId()));
        tripTimes.validateNonIncreasingTimes();
        TripPattern pattern = (TripPattern)TripPattern.of(this.getTripPatternId.apply(trip)).withRoute(trip.getRoute()).withMode(trip.getMode()).withNetexSubmode(trip.getNetexSubMode()).withStopPattern(stopPattern).withScheduledTimeTableBuilder(builder -> builder.addTripTimes(tripTimes)).build();
        RealTimeTripTimesBuilder builder2 = tripTimes.createRealTimeFromScheduledTimes();
        for (int stopSequence = 0; stopSequence < this.calls.size(); ++stopSequence) {
            TimetableHelper.applyUpdates(departureDate, builder2, stopSequence, stopSequence == this.calls.size() - 1, this.isJourneyPredictionInaccurate, this.calls.get(stopSequence), this.occupancy);
        }
        if (this.cancellation || stopPattern.isAllStopsNonRoutable()) {
            builder2.cancelTrip();
        } else {
            builder2.withRealTimeState(RealTimeState.ADDED);
        }
        TripOnServiceDate tripOnServiceDate = (TripOnServiceDate)TripOnServiceDate.of(this.tripId).withTrip(trip).withServiceDate(this.serviceDate).withReplacementFor(this.replacedTrips).build();
        try {
            return Result.success(new TripUpdate(stopPattern, builder2.build(), this.serviceDate, tripOnServiceDate, pattern, isAddedRoute, this.dataSource));
        }
        catch (DataValidationException e) {
            return DataValidationExceptionMapper.toResult(e, this.dataSource);
        }
    }

    private Route createRoute(Agency agency) {
        RouteBuilder routeBuilder = Route.of(this.entityResolver.resolveId(this.lineRef));
        routeBuilder.withShortName(this.shortName);
        routeBuilder.withMode(this.transitMode);
        routeBuilder.withNetexSubmode(this.transitSubMode);
        routeBuilder.withOperator(this.operator);
        routeBuilder.withAgency(agency);
        return (Route)routeBuilder.build();
    }

    @Nullable
    private Agency resolveAgency() {
        return this.transitService.listRoutes().stream().filter(r -> r != null && r.getOperator() != null && r.getOperator().equals(this.operator)).findFirst().map(Route::getAgency).orElseGet(() -> this.replacedRoute != null ? this.replacedRoute.getAgency() : null);
    }

    private Trip createTrip(Route route, FeedScopedId calServiceId) {
        TripBuilder tripBuilder = Trip.of(this.tripId);
        tripBuilder.withRoute(route);
        tripBuilder.withMode(this.transitMode);
        tripBuilder.withNetexSubmode(this.transitSubMode);
        tripBuilder.withServiceId(calServiceId);
        tripBuilder.withHeadsign(NonLocalizedString.ofNullable(this.headsign));
        tripBuilder.withOperator(this.operator);
        return (Trip)tripBuilder.build();
    }

    static String resolveTransitSubMode(TransitMode transitMode, Route replacedRoute) {
        if (replacedRoute == null) {
            return null;
        }
        TransitMode replacedRouteMode = replacedRoute.getMode();
        if (replacedRouteMode != TransitMode.RAIL) {
            return null;
        }
        return switch (transitMode) {
            case TransitMode.RAIL -> RailSubmodeEnumeration.REPLACEMENT_RAIL_SERVICE.value();
            case TransitMode.BUS -> BusSubmodeEnumeration.RAIL_REPLACEMENT_BUS.value();
            default -> null;
        };
    }

    private List<TripOnServiceDate> getReplacedVehicleJourneys(EstimatedVehicleJourney estimatedVehicleJourney) {
        TripOnServiceDate replacedDatedServiceJourney;
        ArrayList<TripOnServiceDate> listOfReplacedVehicleJourneys = new ArrayList<TripOnServiceDate>();
        VehicleJourneyRef vehicleJourneyRef = estimatedVehicleJourney.getVehicleJourneyRef();
        if (vehicleJourneyRef != null && (replacedDatedServiceJourney = this.entityResolver.resolveTripOnServiceDate(vehicleJourneyRef.getValue())) != null) {
            listOfReplacedVehicleJourneys.add(replacedDatedServiceJourney);
        }
        estimatedVehicleJourney.getAdditionalVehicleJourneyReves().stream().map(this.entityResolver::resolveTripOnServiceDate).filter(Objects::nonNull).forEach(listOfReplacedVehicleJourneys::add);
        return listOfReplacedVehicleJourneys;
    }
}

