/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import javax.annotation.Nullable;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.spi.UpdateSuccess;
import org.opentripplanner.updater.trip.UrlUpdaterParameters;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;

public class StreamingTripUpdateMetrics
extends TripUpdateMetrics {
    protected static final String METRICS_PREFIX = "streaming_trip_updates";
    private final boolean producerMetrics;

    public StreamingTripUpdateMetrics(UrlUpdaterParameters parameters) {
        super(parameters);
        this.producerMetrics = parameters.producerMetrics();
    }

    public void setCounters(UpdateResult result) {
        this.incrementWarningCounts(result);
        this.incrementFailureCounts(result);
        this.incrementSuccessCounts(result);
    }

    private void incrementWarningCounts(UpdateResult result) {
        for (UpdateSuccess.WarningType warningType : result.warnings()) {
            Tags tags = Tags.concat((Iterable)this.baseTags, (Iterable)Tags.of((String)"warningType", (String)warningType.name()));
            Counter.builder((String)"streaming_trip_updates.warnings").description("Total warnings by type generated by successful trip updates").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry).increment();
        }
    }

    private Tags andProducerMetrics(Tags tags, @Nullable String producer) {
        if (producer != null && !producer.isEmpty()) {
            return tags.and(new Tag[]{Tag.of((String)"producer", (String)producer)});
        }
        return tags.and(new Tag[]{Tag.of((String)"producer", (String)"unknown_producer")});
    }

    private void incrementFailureCounts(UpdateResult result) {
        for (UpdateError error : result.errors()) {
            Tags tags = Tags.concat((Iterable)this.baseTags, (Iterable)Tags.of((String)"errorType", (String)error.errorType().name()));
            if (this.producerMetrics) {
                tags = this.andProducerMetrics(tags, error.producer());
            }
            Counter.builder((String)"streaming_trip_updates.failed").description("Total failed trip updates").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry).increment();
        }
    }

    private void incrementSuccessCounts(UpdateResult result) {
        for (UpdateSuccess success : result.successes()) {
            Tags tags = Tags.of((Iterable)this.baseTags);
            if (this.producerMetrics) {
                tags = this.andProducerMetrics(tags, success.producer());
            }
            Counter.builder((String)"streaming_trip_updates.successful").description("Total successfully applied trip updates").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry).increment();
        }
    }
}

