/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs.updater.http;

import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.trip.UpdateIncrementality;
import org.opentripplanner.updater.trip.gtfs.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.gtfs.ForwardsDelayPropagationType;
import org.opentripplanner.updater.trip.gtfs.GtfsRealTimeTripUpdateAdapter;
import org.opentripplanner.updater.trip.gtfs.updater.TripUpdateGraphWriterRunnable;
import org.opentripplanner.updater.trip.gtfs.updater.http.HttpTripUpdateSource;
import org.opentripplanner.updater.trip.gtfs.updater.http.PollingTripUpdaterParameters;
import org.opentripplanner.updater.trip.metrics.BatchTripUpdateMetrics;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingTripUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PollingTripUpdater.class);
    private final HttpTripUpdateSource updateSource;
    private final GtfsRealTimeTripUpdateAdapter adapter;
    private final String feedId;
    private final ForwardsDelayPropagationType forwardsDelayPropagationType;
    private final BackwardsDelayPropagationType backwardsDelayPropagationType;
    private final Consumer<UpdateResult> recordMetrics;
    private final boolean fuzzyTripMatching;

    public PollingTripUpdater(PollingTripUpdaterParameters parameters, GtfsRealTimeTripUpdateAdapter adapter) {
        super(parameters);
        this.feedId = parameters.feedId();
        this.updateSource = new HttpTripUpdateSource(parameters);
        this.forwardsDelayPropagationType = parameters.forwardsDelayPropagationType();
        this.backwardsDelayPropagationType = parameters.backwardsDelayPropagationType();
        this.adapter = adapter;
        this.fuzzyTripMatching = parameters.fuzzyTripMatching();
        this.recordMetrics = BatchTripUpdateMetrics.batch(parameters);
        LOG.info("Creating stop time updater running every {} seconds : {}", (Object)this.pollingPeriod(), (Object)this.updateSource);
    }

    @Override
    public void runPolling() throws InterruptedException, ExecutionException {
        List<GtfsRealtime.TripUpdate> updates = this.updateSource.getUpdates();
        UpdateIncrementality incrementality = this.updateSource.incrementalityOfLastUpdates();
        if (updates != null) {
            TripUpdateGraphWriterRunnable runnable = new TripUpdateGraphWriterRunnable(this.adapter, this.fuzzyTripMatching, this.forwardsDelayPropagationType, this.backwardsDelayPropagationType, incrementality, updates, this.feedId, this.recordMetrics);
            this.updateGraph(runnable);
        }
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("updateSource", (Object)this.updateSource).addStr("feedId", this.feedId).addBool("fuzzyTripMatching", Boolean.valueOf(this.fuzzyTripMatching)).toString();
    }
}

