/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs.updater.http;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.transit.realtime.GtfsRealtime;
import de.mfdz.MfdzRealtimeExtensions;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.trip.UpdateIncrementality;
import org.opentripplanner.updater.trip.gtfs.updater.http.PollingTripUpdaterParameters;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpTripUpdateSource {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTripUpdateSource.class);
    private final String feedId;
    private final String url;
    private final HttpHeaders headers;
    private UpdateIncrementality updateIncrementality = UpdateIncrementality.FULL_DATASET;
    private final ExtensionRegistry registry = ExtensionRegistry.newInstance();
    private final OtpHttpClient otpHttpClient;

    public HttpTripUpdateSource(PollingTripUpdaterParameters config) {
        this.feedId = config.feedId();
        this.url = config.url();
        this.headers = HttpHeaders.of().acceptProtobuf().add(config.headers()).build();
        MfdzRealtimeExtensions.registerAllExtensions((ExtensionRegistry)this.registry);
        this.otpHttpClient = new OtpHttpClientFactory().create(LOG);
    }

    public List<GtfsRealtime.TripUpdate> getUpdates() {
        ArrayList<GtfsRealtime.TripUpdate> updates = null;
        this.updateIncrementality = UpdateIncrementality.FULL_DATASET;
        try {
            GtfsRealtime.FeedMessage feedMessage = this.otpHttpClient.getAndMap(URI.create(this.url), this.headers.asMap(), is -> GtfsRealtime.FeedMessage.parseFrom((InputStream)is, (ExtensionRegistryLite)this.registry));
            List feedEntityList = feedMessage.getEntityList();
            if (feedMessage.hasHeader() && feedMessage.getHeader().hasIncrementality() && feedMessage.getHeader().getIncrementality().equals((Object)GtfsRealtime.FeedHeader.Incrementality.DIFFERENTIAL)) {
                this.updateIncrementality = UpdateIncrementality.DIFFERENTIAL;
            }
            updates = new ArrayList<GtfsRealtime.TripUpdate>(feedEntityList.size());
            for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                if (!feedEntity.hasTripUpdate()) continue;
                updates.add(feedEntity.getTripUpdate());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to process GTFS-RT TripUpdates feed from {}", (Object)this.url, (Object)e);
        }
        return updates;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("feedId", this.feedId).addStr("url", this.url).toString();
    }

    public UpdateIncrementality incrementalityOfLastUpdates() {
        return this.updateIncrementality;
    }
}

