/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs.model;

import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.updater.trip.gtfs.model.StopTimeUpdate;
import org.opentripplanner.updater.trip.gtfs.model.TripDescriptor;

public final class TripUpdate {
    private final GtfsRealtime.TripUpdate tripUpdate;

    public TripUpdate(GtfsRealtime.TripUpdate tripUpdate) {
        this.tripUpdate = tripUpdate;
    }

    public TripDescriptor tripDescriptor() {
        return new TripDescriptor(this.tripUpdate.getTrip());
    }

    public List<StopTimeUpdate> stopTimeUpdates() {
        return this.tripUpdate.getStopTimeUpdateList().stream().map(StopTimeUpdate::new).collect(Collectors.toList());
    }

    public Optional<I18NString> tripHeadsign() {
        return this.tripProperties().flatMap(p -> p.hasTripHeadsign() ? Optional.of(I18NString.of(p.getTripHeadsign())) : Optional.empty());
    }

    public Optional<String> tripShortName() {
        return this.tripProperties().flatMap(p -> p.hasTripShortName() ? Optional.of(p.getTripShortName()) : Optional.empty());
    }

    private Optional<GtfsRealtime.TripUpdate.TripProperties> tripProperties() {
        return this.tripUpdate.hasTripProperties() ? Optional.of(this.tripUpdate.getTripProperties()) : Optional.empty();
    }

    public Optional<GtfsRealtime.VehicleDescriptor> vehicle() {
        return this.tripUpdate.hasVehicle() ? Optional.of(this.tripUpdate.getVehicle()) : Optional.empty();
    }
}

