/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs.model;

import com.google.transit.realtime.GtfsRealtime;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Optional;
import java.util.OptionalInt;
import org.opentripplanner.utils.lang.StringUtils;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.opentripplanner.utils.time.TimeUtils;

public class TripDescriptor {
    private final GtfsRealtime.TripDescriptor tripDescriptor;

    public TripDescriptor(GtfsRealtime.TripDescriptor tripDescriptor) {
        this.tripDescriptor = tripDescriptor;
    }

    public Optional<String> tripId() {
        return this.tripDescriptor.hasTripId() ? Optional.of(this.tripDescriptor.getTripId()).filter(StringUtils::hasValue) : Optional.empty();
    }

    public Optional<String> routeId() {
        return this.tripDescriptor.hasRouteId() ? Optional.of(this.tripDescriptor.getRouteId()) : Optional.empty();
    }

    public OptionalInt startTime() {
        return this.tripDescriptor.hasStartTime() ? OptionalInt.of(TimeUtils.time((String)this.tripDescriptor.getStartTime())) : OptionalInt.empty();
    }

    public Optional<LocalDate> startDate() throws ParseException {
        return this.tripDescriptor.hasStartDate() ? Optional.of(ServiceDateUtils.parseString((String)this.tripDescriptor.getStartDate())) : Optional.empty();
    }

    public GtfsRealtime.TripDescriptor.ScheduleRelationship scheduleRelationship() {
        return this.tripDescriptor.hasScheduleRelationship() ? this.tripDescriptor.getScheduleRelationship() : GtfsRealtime.TripDescriptor.ScheduleRelationship.SCHEDULED;
    }

    GtfsRealtime.TripDescriptor original() {
        return this.tripDescriptor;
    }
}

