/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs.model;

import com.google.transit.realtime.GtfsRealtime;
import de.mfdz.MfdzRealtimeExtensions;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.gtfs.mapping.PickDropMapper;
import org.opentripplanner.model.PickDrop;

public final class StopTimeUpdate {
    private final GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate;

    public StopTimeUpdate(GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate) {
        this.stopTimeUpdate = stopTimeUpdate;
    }

    public Optional<PickDrop> pickup() {
        return this.stopTimeProperties().flatMap(p -> p.hasPickupType() ? Optional.of(p.getPickupType().getNumber()) : Optional.empty()).or(() -> this.stopTimePropertiesExtension().flatMap(p -> p.hasPickupType() ? Optional.of(p.getPickupType().getNumber()) : Optional.empty())).map(PickDropMapper::map);
    }

    public Optional<PickDrop> dropoff() {
        return this.stopTimeProperties().flatMap(p -> p.hasDropOffType() ? Optional.of(p.getDropOffType().getNumber()) : Optional.empty()).or(() -> this.stopTimePropertiesExtension().flatMap(p -> p.hasDropoffType() ? Optional.of(p.getDropoffType().getNumber()) : Optional.empty())).map(PickDropMapper::map);
    }

    public PickDrop effectivePickup() {
        return this.getEffectivePickDrop(this.stopTimeProperties().map(properties -> properties.hasPickupType() ? properties.getPickupType() : null).orElse(null), this.stopTimePropertiesExtension().map(properties -> properties.hasPickupType() ? properties.getPickupType() : null).orElse(null));
    }

    public PickDrop effectiveDropoff() {
        return this.getEffectivePickDrop(this.stopTimeProperties().map(properties -> properties.hasDropOffType() ? properties.getDropOffType() : null).orElse(null), this.stopTimePropertiesExtension().map(properties -> properties.hasDropoffType() ? properties.getDropoffType() : null).orElse(null));
    }

    public GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship scheduleRelationship() {
        return this.stopTimeUpdate.getScheduleRelationship();
    }

    public OptionalLong scheduledArrivalTimeWithRealTimeFallback() {
        return this.stopTimeUpdate.hasArrival() ? this.getScheduledTimeWithRealTimeFallback(this.stopTimeUpdate.getArrival()) : OptionalLong.empty();
    }

    public OptionalLong arrivalTime() {
        return this.stopTimeUpdate.hasArrival() ? this.getTime(this.stopTimeUpdate.getArrival()) : OptionalLong.empty();
    }

    public OptionalLong scheduledDepartureTimeWithRealTimeFallback() {
        return this.stopTimeUpdate.hasDeparture() ? this.getScheduledTimeWithRealTimeFallback(this.stopTimeUpdate.getDeparture()) : OptionalLong.empty();
    }

    public OptionalLong departureTime() {
        return this.stopTimeUpdate.hasDeparture() ? this.getTime(this.stopTimeUpdate.getDeparture()) : OptionalLong.empty();
    }

    public OptionalInt arrivalDelay() {
        return this.stopTimeUpdate.hasArrival() ? this.getDelay(this.stopTimeUpdate.getArrival()) : OptionalInt.empty();
    }

    public OptionalInt departureDelay() {
        return this.stopTimeUpdate.hasDeparture() ? this.getDelay(this.stopTimeUpdate.getDeparture()) : OptionalInt.empty();
    }

    public boolean isArrivalValid() {
        return !this.stopTimeUpdate.hasArrival() || this.stopTimeUpdate.getArrival().hasTime() || this.stopTimeUpdate.getArrival().hasDelay();
    }

    public boolean isDepartureValid() {
        return !this.stopTimeUpdate.hasDeparture() || this.stopTimeUpdate.getDeparture().hasTime() || this.stopTimeUpdate.getDeparture().hasDelay();
    }

    public boolean isSkipped() {
        return this.stopTimeUpdate.getScheduleRelationship() == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED;
    }

    public OptionalInt stopSequence() {
        return this.stopTimeUpdate.hasStopSequence() ? OptionalInt.of(this.stopTimeUpdate.getStopSequence()) : OptionalInt.empty();
    }

    public Optional<String> stopId() {
        return this.stopTimeUpdate.hasStopId() ? Optional.of(this.stopTimeUpdate.getStopId()) : Optional.empty();
    }

    public Optional<I18NString> stopHeadsign() {
        return this.stopTimeUpdate.hasStopTimeProperties() && this.stopTimeUpdate.getStopTimeProperties().hasStopHeadsign() ? Optional.of(I18NString.of(this.stopTimeUpdate.getStopTimeProperties().getStopHeadsign())) : Optional.empty();
    }

    public Optional<String> assignedStopId() {
        return this.stopTimeProperties().flatMap(p -> p.hasAssignedStopId() ? Optional.of(p.getAssignedStopId()) : Optional.empty());
    }

    private PickDrop getEffectivePickDrop(@Nullable GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.DropOffPickupType dropOffPickupType, @Nullable MfdzRealtimeExtensions.StopTimePropertiesExtension.DropOffPickupType extensionDropOffPickup) {
        if (this.isSkipped()) {
            return PickDrop.CANCELLED;
        }
        if (dropOffPickupType != null) {
            return PickDropMapper.map(dropOffPickupType.getNumber());
        }
        if (extensionDropOffPickup != null) {
            return PickDropMapper.map(extensionDropOffPickup.getNumber());
        }
        return PickDrop.SCHEDULED;
    }

    private Optional<GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties> stopTimeProperties() {
        return this.stopTimeUpdate.hasStopTimeProperties() ? Optional.of(this.stopTimeUpdate.getStopTimeProperties()) : Optional.empty();
    }

    private Optional<MfdzRealtimeExtensions.StopTimePropertiesExtension> stopTimePropertiesExtension() {
        return this.stopTimeProperties().map(stopTimeProperties -> stopTimeProperties.hasExtension(MfdzRealtimeExtensions.stopTimeProperties) ? (MfdzRealtimeExtensions.StopTimePropertiesExtension)stopTimeProperties.getExtension(MfdzRealtimeExtensions.stopTimeProperties) : null);
    }

    private OptionalLong getTime(GtfsRealtime.TripUpdate.StopTimeEvent stopTimeEvent) {
        return stopTimeEvent.hasTime() ? OptionalLong.of(stopTimeEvent.getTime()) : OptionalLong.empty();
    }

    private OptionalLong getScheduledTimeWithRealTimeFallback(GtfsRealtime.TripUpdate.StopTimeEvent stopTimeEvent) {
        return stopTimeEvent.hasScheduledTime() ? OptionalLong.of(stopTimeEvent.getScheduledTime()) : this.getTime(stopTimeEvent).stream().map(time -> time - (long)this.getDelay(stopTimeEvent).orElse(0)).findFirst();
    }

    private OptionalInt getDelay(GtfsRealtime.TripUpdate.StopTimeEvent stopTimeEvent) {
        return stopTimeEvent.hasDelay() ? OptionalInt.of(stopTimeEvent.getDelay()) : (stopTimeEvent.hasTime() && stopTimeEvent.hasScheduledTime() ? OptionalInt.of((int)(stopTimeEvent.getTime() - stopTimeEvent.getScheduledTime())) : OptionalInt.empty());
    }
}

